/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.api.BoatModule;
import org.jglrxavpok.moarboats.api.BoatModuleInventory;
import org.jglrxavpok.moarboats.api.BoatModuleRegistry;
import org.jglrxavpok.moarboats.common.containers.ContainerHelmModule;
import org.jglrxavpok.moarboats.common.data.LoopingOptions;
import org.jglrxavpok.moarboats.common.entities.ModularBoatEntity;
import org.jglrxavpok.moarboats.common.items.MapItemWithPath;
import org.jglrxavpok.moarboats.common.modules.HelmModule;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;
import org.jglrxavpok.moarboats.common.network.MoarBoatsPacket;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CSaveItineraryToMap;", "Lorg/jglrxavpok/moarboats/common/network/MoarBoatsPacket;", "boatID", "", "moduleID", "Lnet/minecraft/util/ResourceLocation;", "(ILnet/minecraft/util/ResourceLocation;)V", "()V", "Handler", "moarboats"})
public final class CSaveItineraryToMap
implements MoarBoatsPacket {
    private int boatID;
    private ResourceLocation moduleID;

    public CSaveItineraryToMap() {
        this.moduleID = new ResourceLocation("moarboats", "none");
    }

    public CSaveItineraryToMap(int boatID, @NotNull ResourceLocation moduleID) {
        Intrinsics.checkParameterIsNotNull((Object)moduleID, (String)"moduleID");
        this();
        this.boatID = boatID;
        this.moduleID = moduleID;
    }

    @Override
    public void encode(@NotNull PacketBuffer to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        MoarBoatsPacket.DefaultImpls.encode(this, to);
    }

    @Override
    @NotNull
    public MoarBoatsPacket decode(@NotNull PacketBuffer from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return MoarBoatsPacket.DefaultImpls.decode(this, from);
    }

    public static final /* synthetic */ void access$setBoatID$p(CSaveItineraryToMap $this, int n) {
        $this.boatID = n;
    }

    public static final /* synthetic */ void access$setModuleID$p(CSaveItineraryToMap $this, ResourceLocation resourceLocation) {
        $this.moduleID = resourceLocation;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/CSaveItineraryToMap$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/CSaveItineraryToMap;", "Lorg/jglrxavpok/moarboats/common/network/MoarBoatsPacket;", "()V", "packetClass", "Ljava/lang/Class;", "getPacketClass", "()Ljava/lang/Class;", "receiverSide", "Lnet/minecraftforge/api/distmarker/Dist;", "getReceiverSide", "()Lnet/minecraftforge/api/distmarker/Dist;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/network/NetworkEvent$Context;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<CSaveItineraryToMap, MoarBoatsPacket> {
        @NotNull
        private static final Class<CSaveItineraryToMap> packetClass;
        @NotNull
        private static final Dist receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public Class<CSaveItineraryToMap> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Dist getReceiverSide() {
            return receiverSide;
        }

        @Override
        @Nullable
        public MoarBoatsPacket onMessage(@NotNull CSaveItineraryToMap message, @NotNull NetworkEvent.Context ctx) {
            BoatModule module;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            ServerPlayerEntity serverPlayerEntity = ctx.getSender();
            if (serverPlayerEntity == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)serverPlayerEntity, (String)"ctx.sender!!");
            ServerPlayerEntity player = serverPlayerEntity;
            if (!(player.field_71070_bA instanceof ContainerHelmModule)) {
                MoarBoats.INSTANCE.getLogger().warn("Player " + player + " tried to save an itinerary to a map while not in a helm container, they might be lagging or cheating");
                return null;
            }
            World world = player.field_70170_p;
            Entity entity = world.func_73045_a(message.boatID);
            if (!(entity instanceof ModularBoatEntity)) {
                entity = null;
            }
            ModularBoatEntity modularBoatEntity = (ModularBoatEntity)entity;
            if (modularBoatEntity == null) {
                return null;
            }
            ModularBoatEntity boat = modularBoatEntity;
            ResourceLocation moduleLocation = message.moduleID;
            BoatModule boatModule = module = BoatModuleRegistry.INSTANCE.get(moduleLocation).getModule();
            if (boatModule == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jglrxavpok.moarboats.common.modules.HelmModule");
            }
            HelmModule cfr_ignored_0 = (HelmModule)boatModule;
            ListNBT list = ((ListNBT)((HelmModule)module).getWaypointsProperty().get(boat)).func_74737_b();
            BoatModuleInventory inv = boat.getInventory(module);
            ItemStack itemStack = inv.func_70301_a(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inv.getStackInSlot(0)");
            Item item = itemStack.func_77973_b();
            Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"inv.getStackInSlot(0).item");
            if (Intrinsics.areEqual((Object)item.getItem(), (Object)Items.field_151098_aY)) {
                int id = FilledMapItem.func_195949_f((ItemStack)inv.func_70301_a(0));
                ListNBT listNBT = list;
                Intrinsics.checkExpressionValueIsNotNull((Object)listNBT, (String)"list");
                inv.func_70299_a(0, MapItemWithPath.INSTANCE.createStack(listNBT, "map_" + id, (LoopingOptions)((Object)((HelmModule)module).getLoopingProperty().get(boat))));
                player.field_71070_bA.func_75142_b();
            }
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = CSaveItineraryToMap.class;
            receiverSide = Dist.DEDICATED_SERVER;
        }

        @Override
        public void handle(@NotNull CSaveItineraryToMap packet, @NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            MBMessageHandler.DefaultImpls.handle(this, (MoarBoatsPacket)packet, ctx);
        }

        @Override
        public void registerSelf(@NotNull SimpleChannel network2, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network2, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network2, packetID);
        }
    }
}

