/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.client.ClientEvents;
import org.jglrxavpok.moarboats.common.data.MapImageStripe;
import org.jglrxavpok.moarboats.common.network.MBMessageHandler;
import org.jglrxavpok.moarboats.common.network.MoarBoatsPacket;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0001\u0017B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SMapImageAnswer;", "Lorg/jglrxavpok/moarboats/common/network/MoarBoatsPacket;", "name", "", "stripeIndex", "", "textureStripe", "", "(Ljava/lang/String;I[I)V", "()V", "mapName", "getMapName", "()Ljava/lang/String;", "setMapName", "(Ljava/lang/String;)V", "getStripeIndex", "()I", "setStripeIndex", "(I)V", "getTextureStripe", "()[I", "setTextureStripe", "([I)V", "Handler", "moarboats"})
public final class SMapImageAnswer
implements MoarBoatsPacket {
    @NotNull
    private String mapName;
    private int stripeIndex;
    @NotNull
    private int[] textureStripe;

    @NotNull
    public final String getMapName() {
        return this.mapName;
    }

    public final void setMapName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.mapName = string;
    }

    public final int getStripeIndex() {
        return this.stripeIndex;
    }

    public final void setStripeIndex(int n) {
        this.stripeIndex = n;
    }

    @NotNull
    public final int[] getTextureStripe() {
        return this.textureStripe;
    }

    public final void setTextureStripe(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.textureStripe = nArray;
    }

    public SMapImageAnswer() {
        this.mapName = "";
        this.textureStripe = new int[0];
    }

    public SMapImageAnswer(@NotNull String name, int stripeIndex, @NotNull int[] textureStripe) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)textureStripe, (String)"textureStripe");
        this();
        this.mapName = name;
        this.stripeIndex = stripeIndex;
        this.textureStripe = textureStripe;
    }

    @Override
    public void encode(@NotNull PacketBuffer to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        MoarBoatsPacket.DefaultImpls.encode(this, to);
    }

    @Override
    @NotNull
    public MoarBoatsPacket decode(@NotNull PacketBuffer from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return MoarBoatsPacket.DefaultImpls.decode(this, from);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/moarboats/common/network/SMapImageAnswer$Handler;", "Lorg/jglrxavpok/moarboats/common/network/MBMessageHandler;", "Lorg/jglrxavpok/moarboats/common/network/SMapImageAnswer;", "Lorg/jglrxavpok/moarboats/common/network/MoarBoatsPacket;", "()V", "packetClass", "Ljava/lang/Class;", "getPacketClass", "()Ljava/lang/Class;", "receiverSide", "Lnet/minecraftforge/api/distmarker/Dist;", "getReceiverSide", "()Lnet/minecraftforge/api/distmarker/Dist;", "onMessage", "message", "ctx", "Lnet/minecraftforge/fml/network/NetworkEvent$Context;", "moarboats"})
    public static final class Handler
    implements MBMessageHandler<SMapImageAnswer, MoarBoatsPacket> {
        @NotNull
        private static final Class<SMapImageAnswer> packetClass;
        @NotNull
        private static final Dist receiverSide;
        public static final Handler INSTANCE;

        @Override
        @NotNull
        public Class<SMapImageAnswer> getPacketClass() {
            return packetClass;
        }

        @Override
        @NotNull
        public Dist getReceiverSide() {
            return receiverSide;
        }

        @Override
        @Nullable
        public MoarBoatsPacket onMessage(@NotNull SMapImageAnswer message, @NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            String mapID = message.getMapName();
            String id = "moarboats:map_preview/" + mapID + '/' + message.getStripeIndex();
            MapImageStripe data2 = new MapImageStripe(id, message.getStripeIndex(), message.getTextureStripe());
            ClientEvents.INSTANCE.saveMapStripe(data2);
            return null;
        }

        private Handler() {
        }

        static {
            Handler handler;
            INSTANCE = handler = new Handler();
            packetClass = SMapImageAnswer.class;
            receiverSide = Dist.CLIENT;
        }

        @Override
        public void handle(@NotNull SMapImageAnswer packet, @NotNull NetworkEvent.Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            MBMessageHandler.DefaultImpls.handle(this, (MoarBoatsPacket)packet, ctx);
        }

        @Override
        public void registerSelf(@NotNull SimpleChannel network2, int packetID) {
            Intrinsics.checkParameterIsNotNull((Object)network2, (String)"network");
            MBMessageHandler.DefaultImpls.registerSelf(this, network2, packetID);
        }
    }
}

