/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.moarboats.common.tileentity;

import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.moarboats.MoarBoats;
import org.jglrxavpok.moarboats.common.MoarBoatsConfig;
import org.jglrxavpok.moarboats.common.blocks.BlockEnergyUnloaderKt;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityFluidLoader;
import org.jglrxavpok.moarboats.common.tileentity.TileEntityListenable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0014\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J,\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0007H\u0016J\b\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u0007H\u0016J\u0018\u0010+\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0012\u0010+\u001a\u00020\u000f2\b\u0010,\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020.H\u0016J\u0010\u00102\u001a\u0002002\u0006\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityFluidLoader;", "Lorg/jglrxavpok/moarboats/common/tileentity/TileEntityListenable;", "Lnet/minecraft/tileentity/ITickableTileEntity;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "Lnet/minecraftforge/fluids/IFluidTank;", "()V", "amount", "", "blockFacing", "Lnet/minecraft/util/Direction;", "getBlockFacing", "()Lnet/minecraft/util/Direction;", "fluid", "Lnet/minecraft/fluid/Fluid;", "working", "", "canDrain", "canDrainFluidType", "fluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "canFill", "canFillFluidType", "drain", "maxDrain", "action", "Lnet/minecraftforge/fluids/capability/IFluidHandler$FluidAction;", "resource", "fill", "forceDrain", "getCapability", "Lnet/minecraftforge/common/util/LazyOptional;", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "getCapacity", "getFluid", "getFluidAmount", "getFluidInTank", "tank", "getRedstonePower", "getTankCapacity", "getTanks", "isFluidValid", "stack", "read", "", "compound", "Lnet/minecraft/nbt/CompoundNBT;", "tick", "write", "moarboats"})
public final class TileEntityFluidLoader
extends TileEntityListenable
implements ITickableTileEntity,
IFluidHandler,
IFluidTank {
    private Fluid fluid;
    private int amount;
    private boolean working;

    @NotNull
    public final Direction getBlockFacing() {
        World world = this.field_145850_b;
        if (world == null) {
            Intrinsics.throwNpe();
        }
        Comparable comparable = world.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEnergyUnloaderKt.getFacing());
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"world!!.getBlockState(pos).get(Facing)");
        return (Direction)comparable;
    }

    public void func_73660_a() {
        World world = this.field_145850_b;
        if (world == null) {
            Intrinsics.throwNpe();
        }
        if (world.field_72995_K) {
            return;
        }
        this.working = false;
        this.updateListeners();
        if (this.fluid == null) {
            return;
        }
        BlockPos blockPos = this.field_174879_c.func_177972_a(this.getBlockFacing());
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.offset(blockFacing)");
        AxisAlignedBB aabb = this.create3x3AxisAlignedBB(blockPos);
        World world2 = this.field_145850_b;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        List entities2 = world2.func_175647_a(Entity.class, aabb, (Predicate)tick.entities.1.INSTANCE);
        Object object = MoarBoatsConfig.fluidLoader.getSendAmount().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"MoarBoatsConfig.fluidLoader.sendAmount.get()");
        int n = ((Number)object).intValue();
        int n2 = this.amount;
        int totalFluidToSend = Math.min(n, n2);
        int entityCount = entities2.size();
        if (entityCount <= 0) {
            return;
        }
        double d = (double)totalFluidToSend / (double)entityCount;
        int fluidToSendToASingleNeighbor = (int)Math.ceil(d);
        List list = entities2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entities");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            LazyOptional fluidCapa;
            Entity it = (Entity)element$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null), (String)"it.getCapability(Capabil\u2026HANDLER_CAPABILITY, null)");
            fluidCapa.ifPresent((NonNullConsumer)new NonNullConsumer<IFluidHandler>(this, fluidToSendToASingleNeighbor){
                final /* synthetic */ TileEntityFluidLoader this$0;
                final /* synthetic */ int $fluidToSendToASingleNeighbor$inlined;
                {
                    this.this$0 = tileEntityFluidLoader;
                    this.$fluidToSendToASingleNeighbor$inlined = n;
                }

                /*
                 * Unable to fully structure code
                 */
                public final void accept(@NotNull IFluidHandler storage) {
                    Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
                    amountDrained = this.this$0.forceDrain(storage.fill(new FluidStack(TileEntityFluidLoader.access$getFluid$p(this.this$0), this.$fluidToSendToASingleNeighbor$inlined), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    if (TileEntityFluidLoader.access$getWorking$p(this.this$0)) ** GOTO lbl-1000
                    v0 = amountDrained;
                    if ((v0 != null ? Integer.valueOf(v0.getAmount()) : null) > 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    TileEntityFluidLoader.access$setWorking$p(this.this$0, v1);
                }
            });
        }
    }

    @Override
    public int getRedstonePower() {
        int n;
        if (this.working) {
            double ratio = (double)this.amount / (double)this.getCapacity();
            int redstonePower = (int)(ratio * (double)15);
            int n2 = 1;
            n = Math.min(n2, redstonePower);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final FluidStack forceDrain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        if (this.fluid == null) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"FluidStack.EMPTY");
            return fluidStack;
        }
        int n = this.amount;
        int maxDrainable = Math.min(maxDrain, n);
        if (action.execute()) {
            this.amount -= maxDrainable;
            this.func_70296_d();
        }
        return new FluidStack(this.fluid, maxDrainable);
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        if (!this.canDrain()) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"FluidStack.EMPTY");
            return fluidStack;
        }
        if (!this.canDrainFluidType(resource)) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"FluidStack.EMPTY");
            return fluidStack;
        }
        if (Intrinsics.areEqual((Object)resource.getFluid(), (Object)this.fluid) ^ true) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"FluidStack.EMPTY");
            return fluidStack;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        if (!this.canDrain()) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"FluidStack.EMPTY");
            return fluidStack;
        }
        return this.forceDrain(maxDrain, action);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        if (!this.canFill()) {
            return 0;
        }
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        if (this.fluid == null) {
            this.fluid = resource.getFluid();
        }
        if (Intrinsics.areEqual((Object)this.fluid, (Object)resource.getFluid()) ^ true && this.amount > 0) {
            return 0;
        }
        this.fluid = resource.getFluid();
        int n = resource.getAmount();
        int n2 = this.getCapacity() - this.amount;
        int maxFillable = Math.min(n, n2);
        if (action.execute()) {
            this.amount += maxFillable;
            this.func_70296_d();
        }
        return maxFillable;
    }

    public int getCapacity() {
        Object object = MoarBoatsConfig.fluidLoader.getCapacity().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"MoarBoatsConfig.fluidLoader.capacity.get()");
        return ((Number)object).intValue();
    }

    public final boolean canFillFluidType(@Nullable FluidStack fluidStack) {
        return true;
    }

    public final boolean canFill() {
        return true;
    }

    public final boolean canDrainFluidType(@Nullable FluidStack fluidStack) {
        return false;
    }

    public final boolean canDrain() {
        return false;
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? this.getCapacity() : 0;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        FluidStack fluidStack;
        if (this.fluid != null && tank == 0 && this.amount > 0) {
            fluidStack = new FluidStack(this.fluid, this.amount);
        } else {
            FluidStack fluidStack2 = FluidStack.EMPTY;
            fluidStack = fluidStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack2, (String)"FluidStack.EMPTY");
        }
        return fluidStack;
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return true;
    }

    public boolean isFluidValid(@Nullable FluidStack stack) {
        return true;
    }

    public int getFluidAmount() {
        return this.amount;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.getFluidInTank(0);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            LazyOptional lazyOptional = LazyOptional.of((NonNullSupplier)new NonNullSupplier<T>(this){
                final /* synthetic */ TileEntityFluidLoader this$0;

                @NotNull
                public final TileEntityFluidLoader get() {
                    return this.this$0;
                }
                {
                    this.this$0 = tileEntityFluidLoader;
                }
            }).cast();
            Intrinsics.checkExpressionValueIsNotNull((Object)lazyOptional, (String)"LazyOptional.of { this }.cast()");
            return lazyOptional;
        }
        LazyOptional lazyOptional = super.getCapability(capability, facing);
        Intrinsics.checkExpressionValueIsNotNull((Object)lazyOptional, (String)"super.getCapability(capability, facing)");
        return lazyOptional;
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.func_74768_a("fluidAmount", this.amount);
        Object object = this.fluid;
        if (object == null || (object = object.getRegistryName()) == null || (object = object.toString()) == null) {
            object = "";
        }
        compound.func_74778_a("fluidName", (String)object);
        CompoundNBT compoundNBT = super.func_189515_b(compound);
        Intrinsics.checkExpressionValueIsNotNull((Object)compoundNBT, (String)"super.write(compound)");
        return compoundNBT;
    }

    public void func_145839_a(@NotNull CompoundNBT compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(compound.func_74779_i("fluidName")));
        this.amount = compound.func_74762_e("fluidAmount");
    }

    public TileEntityFluidLoader() {
        super(MoarBoats.INSTANCE.getTileEntityFluidLoaderType());
    }

    public static final /* synthetic */ Fluid access$getFluid$p(TileEntityFluidLoader $this) {
        return $this.fluid;
    }

    public static final /* synthetic */ void access$setFluid$p(TileEntityFluidLoader $this, Fluid fluid) {
        $this.fluid = fluid;
    }

    public static final /* synthetic */ boolean access$getWorking$p(TileEntityFluidLoader $this) {
        return $this.working;
    }

    public static final /* synthetic */ void access$setWorking$p(TileEntityFluidLoader $this, boolean bl) {
        $this.working = bl;
    }
}

