/*
 * Decompiled with CFR 0.152.
 */
package com.kowloon.moredogs.common;

import com.kowloon.moredogs.common.DogBegGoal;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Dog
extends TameableEntity {
    protected static final DataParameter<Float> healthData = EntityDataManager.func_187226_a(Dog.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> collarColor = EntityDataManager.func_187226_a(Dog.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> begging = EntityDataManager.func_187226_a(Dog.class, (IDataSerializer)DataSerializers.field_187198_h);
    EntityType<? extends Dog> child;
    protected float headRotationCourse;
    protected float headRotationCourseOld;
    private boolean isWet;
    private boolean isShaking;
    private float timeIsShaking;
    private float prevTimeIsShaking;
    public static final Predicate<LivingEntity> field_213441_bD = p_213440_0_ -> {
        EntityType entitytype = p_213440_0_.func_200600_R();
        return entitytype == EntityType.field_200737_ac || entitytype == EntityType.field_200736_ab || entitytype == EntityType.field_220356_B;
    };

    public Dog(EntityType<? extends Dog> type, World worldIn) {
        super(type, worldIn);
        this.child = type;
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.5, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 0.5, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(9, (Goal)new DogBegGoal(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, field_213441_bD));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(begging, (Object)beg);
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(healthData, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(begging, (Object)false);
        this.field_70180_af.func_187214_a(healthData, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(collarColor, (Object)DyeColor.RED.func_196059_a());
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74774_a("CollarColor", (byte)this.getCollarColor().func_196059_a());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAngry(compound.func_74767_n("Angry"));
        if (compound.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(DyeColor.func_196056_a((int)compound.func_74762_e("CollarColor")));
        }
    }

    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(healthData)).floatValue() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    public Dog createChild(AgeableEntity ageable) {
        Dog child = new Dog(this.child, this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            child.func_184754_b(uuid);
            child.func_70903_f(true);
        }
        return child;
    }

    public DyeColor getCollarColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(collarColor)));
    }

    public void setCollarColor(DyeColor collarcolor) {
        this.field_70180_af.func_187227_b(collarColor, (Object)collarcolor.func_196059_a());
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            WolfEntity wolf;
            Dog dog;
            if (target instanceof Dog && (dog = (Dog)target).func_70909_n() && dog.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof WolfEntity && (wolf = (WolfEntity)target).func_70909_n() && wolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof CatEntity) || !((CatEntity)target).func_70909_n();
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c();
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)otherAnimal;
        if (!dog.func_70909_n()) {
            return false;
        }
        if (dog.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && dog.func_70880_s();
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b()) {
                DyeColor dyecolor;
                if (item.func_219971_r()) {
                    if (item.func_219967_s().func_221467_c() && ((Float)this.field_70180_af.func_187225_a(healthData)).floatValue() < 20.0f) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        this.func_70691_i(item.func_219967_s().func_221466_a());
                        return true;
                    }
                } else if (item instanceof DyeItem && (dyecolor = ((DyeItem)item).func_195962_g()) != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (this.func_152114_e((LivingEntity)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (item == Items.field_151103_aS && !this.isAngry()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(begging);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeIsShaking = 0.0f;
            this.prevTimeIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S()) {
            this.headRotationCourseOld = this.headRotationCourse;
            this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
            if (this.func_203008_ap()) {
                this.isWet = true;
                this.isShaking = false;
                this.timeIsShaking = 0.0f;
                this.prevTimeIsShaking = 0.0f;
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.timeIsShaking == 0.0f) {
                    this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.prevTimeIsShaking = this.timeIsShaking;
                this.timeIsShaking += 0.05f;
                if (this.prevTimeIsShaking >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.prevTimeIsShaking = 0.0f;
                    this.timeIsShaking = 0.0f;
                }
                if (this.timeIsShaking > 0.4f) {
                    float f = (float)this.func_174813_aQ().field_72338_b;
                    int i = (int)(MathHelper.func_76126_a((float)((this.timeIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3d vec3d = this.func_213322_ci();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                        float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    }
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        this.isWet = false;
        this.isShaking = false;
        this.prevTimeIsShaking = 0.0f;
        this.timeIsShaking = 0.0f;
        super.func_70645_a(cause);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isDogWet() {
        return this.isWet;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + MathHelper.func_219799_g((float)p_70915_1_, (float)this.prevTimeIsShaking, (float)this.timeIsShaking) / 2.0f * 0.25f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (MathHelper.func_219799_g((float)p_70923_1_, (float)this.prevTimeIsShaking, (float)this.timeIsShaking) + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return MathHelper.func_219799_g((float)p_70917_1_, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeIsShaking = 0.0f;
            this.prevTimeIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (this.isAngry()) {
            return 0.0f;
        }
        return this.func_70909_n() ? (0.0873f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(healthData)).floatValue()) * 0.02f) * (float)Math.PI : -0.3873f;
    }
}

