/*
 * Decompiled with CFR 0.152.
 */
package com.kowloon.moredogs.common;

import com.kowloon.moredogs.common.Dog;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class DogBegGoal
extends Goal {
    private final Dog dog;
    private PlayerEntity player;
    private final World world;
    private final float minPlayerDistance;
    private int timeoutCounter;
    private final EntityPredicate field_220688_f;

    public DogBegGoal(Dog dog, float minDistance) {
        this.dog = dog;
        this.world = dog.field_70170_p;
        this.minPlayerDistance = minDistance;
        this.field_220688_f = new EntityPredicate().func_221013_a((double)minDistance).func_221008_a().func_221011_b().func_221009_d();
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        this.player = this.world.func_217370_a(this.field_220688_f, (LivingEntity)this.dog);
        return this.player == null ? false : this.hasTemptationItemInHand(this.player);
    }

    public boolean func_75253_b() {
        if (!this.player.func_70089_S()) {
            return false;
        }
        if (this.dog.func_70068_e((Entity)this.player) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.player);
    }

    public void func_75249_e() {
        this.dog.setBegging(true);
        this.timeoutCounter = 40 + this.dog.func_70681_au().nextInt(40);
    }

    public void func_75251_c() {
        this.dog.setBegging(false);
        this.player = null;
    }

    public void func_75246_d() {
        this.dog.func_70671_ap().func_75650_a(this.player.field_70165_t, this.player.field_70163_u + (double)this.player.func_70047_e(), this.player.field_70161_v, 10.0f, (float)this.dog.func_70646_bf());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (this.dog.func_70909_n() && itemstack.func_77973_b() == Items.field_151103_aS) {
                return true;
            }
            if (!this.dog.func_70877_b(itemstack)) continue;
            return true;
        }
        return false;
    }
}

