/*
 * Decompiled with CFR 0.152.
 */
package com.kowloon.moredogs.client.models;

import com.google.common.collect.ImmutableList;
import com.kowloon.moredogs.common.Dog;
import com.kowloon.moredogs.common.GermanShepherd;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.TintedAgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GermanShepherdModel<T extends GermanShepherd>
extends TintedAgeableModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer mane;
    private final ModelRenderer body;
    private final ModelRenderer legLeft;
    private final ModelRenderer legRight;
    private final ModelRenderer legLeftBack;
    private final ModelRenderer legRightBack;
    private final ModelRenderer tail;

    public GermanShepherdModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(-0.5f, 14.375f, -1.5f);
        this.head.func_217178_a("head1", -2.5f, -2.375f, -5.5f, 6, 6, 4, 0.0f, 11, 0);
        this.head.func_217178_a("head2", -1.0f, 0.625f, -8.5f, 3, 3, 3, 0.0f, 11, 12);
        this.head.func_217178_a("head3", 1.5f, -4.375f, -3.5f, 2, 2, 1, 0.0f, 34, 16);
        this.head.func_217178_a("head4", -2.5f, -4.375f, -3.5f, 2, 2, 1, 0.0f, 34, 16);
        this.head.func_217178_a("head5", -2.0f, -5.375f, -3.5f, 1, 1, 1, 0.0f, 35, 14);
        this.head.func_217178_a("head6", 2.0f, -5.375f, -3.5f, 1, 1, 1, 0.0f, 35, 14);
        this.mane = new ModelRenderer((Model)this, 0, 40);
        this.mane.func_78793_a(0.0f, 15.0f, -1.5f);
        this.mane.func_228303_a_(-3.5f, -3.5f, -1.5f, 7.0f, 7.0f, 4.0f, 0.0f, false);
        this.body = new ModelRenderer((Model)this, 0, 20);
        this.body.func_78793_a(0.0f, 14.75f, -2.75f);
        this.body.func_228303_a_(-3.0f, -2.75f, 1.75f, 6.0f, 6.0f, 13.0f, 0.0f, false);
        this.legLeft = new ModelRenderer((Model)this, 0, 0);
        this.legLeft.func_78793_a(2.0f, 17.5f, 0.0f);
        this.legLeft.func_228303_a_(-1.5f, -0.5f, -1.0f, 2.0f, 7.0f, 2.0f, 0.0f, false);
        this.legRight = new ModelRenderer((Model)this, 0, 0);
        this.legRight.func_78793_a(-3.0f, 17.0f, 0.0f);
        this.legRight.func_228303_a_(0.5f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, 0.0f, false);
        this.legLeftBack = new ModelRenderer((Model)this, 0, 0);
        this.legLeftBack.func_78793_a(2.0f, 17.5f, 10.0f);
        this.legLeftBack.func_228303_a_(-1.5f, -0.5f, -1.0f, 2.0f, 7.0f, 2.0f, 0.0f, false);
        this.legRightBack = new ModelRenderer((Model)this, 0, 0);
        this.legRightBack.func_78793_a(-2.0f, 17.5f, 10.0f);
        this.legRightBack.func_228303_a_(-0.5f, -0.5f, -1.0f, 2.0f, 7.0f, 2.0f, 0.0f, false);
        this.tail = new ModelRenderer((Model)this, 41, 29);
        this.tail.func_78793_a(0.0f, 13.5f, 11.0f);
        this.tail.func_228303_a_(-1.0f, -1.3f, 0.0f, 2.0f, 2.0f, 7.0f, 0.0f, false);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.field_217114_e) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStackIn.func_227861_a_(0.0, (double)1.4725f, 0.0);
            this.head.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.body.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.mane.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legLeft.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legLeftBack.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legRight.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legRightBack.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.tail.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStackIn.func_227865_b_();
        } else {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.0);
            this.head.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.body.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.mane.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legLeft.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legLeftBack.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legRight.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.legRightBack.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.tail.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStackIn.func_227865_b_();
        }
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.tail.field_78796_g = ((Dog)((Object)entityIn)).isAngry() ? 0.0f : MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (entityIn.func_70906_o()) {
            this.head.func_78793_a(-0.5f, 14.375f, -1.5f);
            this.mane.func_78793_a(0.0f, 15.4f, -2.2765f);
            this.mane.field_78795_f = -0.1745f;
            this.body.func_78793_a(0.0f, 14.75f, -2.75f);
            this.body.field_78795_f = -0.4363f;
            this.legLeft.func_78793_a(2.0f, 17.5f, 0.0f);
            this.legLeft.field_78795_f = 0.0f;
            this.legRight.func_78793_a(-3.0f, 17.0f, 0.0f);
            this.legRight.field_78795_f = 0.0f;
            this.legLeftBack.func_78793_a(2.0f, 22.5f, 8.5f);
            this.legLeftBack.field_78795_f = -1.5708f;
            this.legRightBack.func_78793_a(-2.0f, 22.5f, 8.5f);
            this.legRightBack.field_78795_f = -1.5708f;
            this.tail.func_78793_a(0.0f, 20.0947f, 10.2837f);
        } else {
            this.head.func_78793_a(-0.5f, 14.375f, -1.5f);
            this.mane.func_78793_a(0.0f, 15.0f, -1.5f);
            this.mane.field_78795_f = 0.0f;
            this.body.func_78793_a(0.0f, 14.75f, -2.75f);
            this.body.field_78795_f = 0.0f;
            this.legLeftBack.func_78793_a(2.0f, 17.5f, 10.0f);
            this.legRightBack.func_78793_a(-2.0f, 17.5f, 10.0f);
            this.tail.func_78793_a(0.0f, 13.5f, 11.0f);
            this.legRightBack.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.legLeftBack.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        this.head.field_78808_h = ((Dog)((Object)entityIn)).getInterestedAngle(partialTick) + ((Dog)((Object)entityIn)).getShakeAngle(partialTick, 0.0f);
        this.mane.field_78808_h = ((Dog)((Object)entityIn)).getShakeAngle(partialTick, -0.08f);
        this.body.field_78808_h = ((Dog)((Object)entityIn)).getShakeAngle(partialTick, -0.16f);
        this.tail.field_78808_h = ((Dog)((Object)entityIn)).getShakeAngle(partialTick, -0.2f);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.tail.field_78795_f = entityIn.func_70906_o() ? -0.0873f : ((GermanShepherd)((Object)entityIn)).getTailRotation();
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.legRightBack, (Object)this.legLeftBack, (Object)this.legRight, (Object)this.legLeft, (Object)this.tail, (Object)this.mane);
    }
}

