/*
 * Decompiled with CFR 0.152.
 */
package com.kowloon.moredogs.common;

import com.google.common.collect.Maps;
import com.kowloon.moredogs.common.Dog;
import com.kowloon.moredogs.core.MoreDogsRegistries;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Chihuahua
extends Dog {
    EntityType<? extends Chihuahua> child;
    private static final DataParameter<Integer> CHIHUAHUA_TYPE = EntityDataManager.func_187226_a(Chihuahua.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Map<Integer, ResourceLocation> coatMap = (Map)Util.func_200696_a((Object)Maps.newHashMap(), coats -> {
        coats.put(0, MoreDogsRegistries.location("textures/entity/chihuahua/chihuahua.png"));
        coats.put(1, MoreDogsRegistries.location("textures/entity/chihuahua/chihuahua_1.png"));
        coats.put(2, MoreDogsRegistries.location("textures/entity/chihuahua/chihuahua_2.png"));
    });
    public static final Map<Integer, ResourceLocation> angryCoatMap = (Map)Util.func_200696_a((Object)Maps.newHashMap(), coats -> {
        coats.put(0, MoreDogsRegistries.location("textures/entity/chihuahua/chihuahua_angry.png"));
        coats.put(1, MoreDogsRegistries.location("textures/entity/chihuahua/chihuahua_1_angry.png"));
        coats.put(2, MoreDogsRegistries.location("textures/entity/chihuahua/chihuahua_2_angry.png"));
    });
    private static final Predicate<LivingEntity> field_213441_bD = p_213440_0_ -> {
        EntityType entitytype = p_213440_0_.func_200600_R();
        return entitytype == EntityType.field_200737_ac || entitytype == EntityType.field_200736_ab || entitytype == EntityType.field_220356_B;
    };

    public Chihuahua(EntityType<? extends Chihuahua> type, World worldIn) {
        super(type, worldIn);
        this.child = type;
        this.func_70903_f(false);
    }

    private void setDogCoat(int coat) {
        if (coat < 0 || coat > 2) {
            coat = this.field_70146_Z.nextInt(3);
        }
        this.field_70180_af.func_187227_b(CHIHUAHUA_TYPE, (Object)coat);
    }

    public int getDogCoat() {
        return (Integer)this.field_70180_af.func_187225_a(CHIHUAHUA_TYPE);
    }

    public ResourceLocation getTexture() {
        if (this.isAngry()) {
            return angryCoatMap.get(this.getDogCoat());
        }
        return coatMap.get(this.getDogCoat());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setDogCoat(this.field_70146_Z.nextInt(3));
        return spawnDataIn;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHIHUAHUA_TYPE, (Object)1);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("CoatType", this.getDogCoat());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setDogCoat(compound.func_74762_e("CoatType"));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    public Chihuahua createChild(AgeableEntity ageable) {
        Chihuahua child = new Chihuahua(this.child, this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            child.func_184754_b(uuid);
            child.func_70903_f(true);
        }
        child.setDogCoat(this.getDogCoat());
        return child;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (this.isAngry()) {
            return 0.0f;
        }
        return this.func_70909_n() ? (0.1818f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(healthData)).floatValue()) * 0.02f) * (float)Math.PI : -0.7854f;
    }
}

