/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.network.IMessage;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.MorphTool;
import vazkii.morphtool.MorphingHandler;
import vazkii.morphtool.network.MessageMorphTool;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    public static final ClientHandler INSTANCE = new ClientHandler();
    protected static boolean autoMode = true;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        ItemStack mainHandItem;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && event.phase == TickEvent.Phase.END && autoMode && MorphingHandler.isMorphTool(mainHandItem = player.func_184586_b((Boolean)ConfigHandler.invertHandShift.get() != false ? Hand.OFF_HAND : Hand.MAIN_HAND))) {
            ItemStack newStack = mainHandItem;
            RayTraceResult res = MorphingHandler.raycast((Entity)player, 4.5);
            if (res != null && res.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockState state = player.field_70170_p.func_180495_p(((BlockRayTraceResult)res).func_216350_a());
                String modlook = MorphingHandler.getModFromState(state);
                newStack = MorphingHandler.getShiftStackForMod(mainHandItem, modlook);
            }
            if (newStack != mainHandItem && !ItemStack.func_179545_c((ItemStack)newStack, (ItemStack)mainHandItem)) {
                player.field_71071_by.func_70299_a((Boolean)ConfigHandler.invertHandShift.get() != false ? player.field_71071_by.func_70302_i_() - 1 : player.field_71071_by.field_70461_c, newStack);
                MorphTool.NETWORKHANDLER.sendToServer((IMessage)new MessageMorphTool(newStack, player.field_71071_by.field_70461_c));
                MorphTool.proxy.updateEquippedItem();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        ItemStack mainHandItem;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && MorphingHandler.isMorphTool(mainHandItem = player.func_184586_b((Boolean)ConfigHandler.invertHandShift.get() != false ? Hand.OFF_HAND : Hand.MAIN_HAND))) {
            ItemStack newStack = mainHandItem;
            String mod = MorphingHandler.getModFromStack(mainHandItem);
            RayTraceResult res = MorphingHandler.raycast((Entity)player, 4.5);
            String modlook = "";
            if (res != null && res.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockState state = player.field_70170_p.func_180495_p(((BlockRayTraceResult)res).func_216350_a());
                modlook = MorphingHandler.getModFromState(state);
            }
            if (event.getScrollDelta() != 0.0 && player.func_213453_ef() && !modlook.equals(mod) && mainHandItem.func_77978_p() != null) {
                CompoundNBT morphData = mainHandItem.func_77978_p().func_74775_l("morphtool:data");
                mod = event.getScrollDelta() < 0.0 ? ClientHandler.nextMod(morphData, mod) : ClientHandler.previousMod(morphData, mod);
                newStack = MorphingHandler.getShiftStackForMod(mainHandItem, mod);
                autoMode = mod.equals("morphtool");
                event.setCanceled(true);
            }
            if (newStack != mainHandItem && !ItemStack.func_179545_c((ItemStack)newStack, (ItemStack)mainHandItem)) {
                player.field_71071_by.func_70299_a((Boolean)ConfigHandler.invertHandShift.get() != false ? player.field_71071_by.func_70302_i_() - 1 : player.field_71071_by.field_70461_c, newStack);
                MorphTool.NETWORKHANDLER.sendToServer((IMessage)new MessageMorphTool(newStack, player.field_71071_by.field_70461_c));
                MorphTool.proxy.updateEquippedItem();
            }
        }
    }

    public static String nextMod(CompoundNBT morphData, String mod) {
        ArrayList<String> mods = new ArrayList<String>(morphData.func_150296_c());
        mods.add("morphtool");
        if (!mod.equals("morphtool")) {
            mods.add(mod);
        }
        Collections.sort(mods);
        int id = mods.indexOf(mod);
        int retid = 0;
        if (mods.size() > id + 1) {
            retid = id + 1;
        }
        return (String)mods.get(retid);
    }

    public static String previousMod(CompoundNBT morphData, String mod) {
        ArrayList<String> mods = new ArrayList<String>(morphData.func_150296_c());
        mods.add("morphtool");
        if (!mod.equals("morphtool")) {
            mods.add(mod);
        }
        Collections.sort(mods);
        int id = mods.indexOf(mod);
        int retid = mods.size() - 1;
        if (0 <= id - 1) {
            retid = id - 1;
        }
        return (String)mods.get(retid);
    }
}

