/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.ModItems;

public final class MorphingHandler {
    public static final MorphingHandler INSTANCE = new MorphingHandler();
    public static final String MINECRAFT = "minecraft";
    public static final String TAG_MORPHING_TOOL = "morphtool:is_morphing";
    public static final String TAG_MORPH_TOOL_DATA = "morphtool:data";
    public static final String TAG_MORPH_TOOL_DISPLAY_NAME = "morphtool:displayName";
    private static final Map<String, String> modNames = new HashMap<String, String>();

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().func_213453_ef()) {
            return;
        }
        ItemEntity e = event.getEntityItem();
        ItemStack stack = e.func_92059_d();
        MorphingHandler.removeItemFromTool((Entity)e, stack, false, copy -> e.func_92058_a(copy));
    }

    @SubscribeEvent
    public void onItemBroken(PlayerDestroyItemEvent event) {
        MorphingHandler.removeItemFromTool((Entity)event.getPlayer(), event.getOriginal(), true, morph -> event.getPlayer().func_184611_a(event.getHand(), morph));
    }

    public static void removeItemFromTool(Entity e, ItemStack stack, boolean itemBroken, Consumer<ItemStack> consumer) {
        if (!stack.func_190926_b() && MorphingHandler.isMorphTool(stack) && stack.func_77973_b() != ModItems.tool) {
            CompoundNBT morphData = stack.func_77978_p().func_74775_l(TAG_MORPH_TOOL_DATA).func_74737_b();
            ItemStack morph = MorphingHandler.makeMorphedStack(stack, MINECRAFT, morphData);
            CompoundNBT newMorphData = morph.func_77978_p().func_74775_l(TAG_MORPH_TOOL_DATA);
            newMorphData.func_82580_o(MorphingHandler.getModFromStack(stack));
            if (!itemBroken) {
                ItemStack copy;
                CompoundNBT copyCmp;
                if (!e.func_130014_f_().field_72995_K) {
                    ItemEntity newItem = new ItemEntity(e.func_130014_f_(), (double)e.field_70118_ct, (double)e.field_70117_cu, (double)e.field_70116_cv, morph);
                    e.func_130014_f_().func_217376_c((Entity)newItem);
                }
                if ((copyCmp = (copy = stack.func_77946_l()).func_77978_p()) == null) {
                    copyCmp = new CompoundNBT();
                    copy.func_77982_d(copyCmp);
                }
                copyCmp.func_82580_o("display");
                String displayName = copyCmp.func_74779_i(TAG_MORPH_TOOL_DISPLAY_NAME);
                if (!displayName.isEmpty() && !displayName.equals(copy.func_200301_q().getString())) {
                    copy.func_200302_a(ITextComponent.Serializer.func_150699_a((String)displayName));
                }
                copyCmp.func_82580_o(TAG_MORPHING_TOOL);
                copyCmp.func_82580_o(TAG_MORPH_TOOL_DISPLAY_NAME);
                copyCmp.func_82580_o(TAG_MORPH_TOOL_DATA);
                consumer.accept(copy);
            } else {
                consumer.accept(morph);
            }
        }
    }

    public static String getModFromState(BlockState state) {
        return MorphingHandler.getModOrAlias(state.func_177230_c().getRegistryName().func_110624_b());
    }

    public static String getModFromStack(ItemStack stack) {
        return MorphingHandler.getModOrAlias(stack.func_190926_b() ? MINECRAFT : stack.func_77973_b().getCreatorModId(stack));
    }

    public static String getModOrAlias(String mod) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (String s : (List)ConfigHandler.aliasesList.get()) {
            if (!s.matches(".+?=.+")) continue;
            String[] tokens = s.toLowerCase().split("=");
            aliases.put(tokens[0], tokens[1]);
        }
        return aliases.getOrDefault(mod, mod);
    }

    public static ItemStack getShiftStackForMod(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return stack;
        }
        String currentMod = MorphingHandler.getModFromStack(stack);
        if (mod.equals(currentMod)) {
            return stack;
        }
        CompoundNBT morphData = stack.func_77978_p().func_74775_l(TAG_MORPH_TOOL_DATA);
        return MorphingHandler.makeMorphedStack(stack, mod, morphData);
    }

    public static ItemStack makeMorphedStack(ItemStack currentStack, String targetMod, CompoundNBT morphData) {
        ItemStack stack;
        String currentMod = MorphingHandler.getModFromStack(currentStack);
        CompoundNBT currentCmp = new CompoundNBT();
        currentStack.func_77955_b(currentCmp);
        currentCmp = currentCmp.func_74737_b();
        if (currentCmp.func_74764_b("tag")) {
            currentCmp.func_74775_l("tag").func_82580_o(TAG_MORPH_TOOL_DATA);
        }
        if (!currentMod.equalsIgnoreCase(MINECRAFT) && !currentMod.equalsIgnoreCase("morphtool")) {
            morphData.func_218657_a(currentMod, (INBT)currentCmp);
        }
        if (targetMod.equals(MINECRAFT)) {
            stack = new ItemStack((IItemProvider)ModItems.tool);
        } else {
            CompoundNBT targetCmp = morphData.func_74775_l(targetMod);
            morphData.func_82580_o(targetMod);
            stack = ItemStack.func_199557_a((CompoundNBT)targetCmp);
            if (stack.func_190926_b()) {
                stack = new ItemStack((IItemProvider)ModItems.tool);
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT stackCmp = stack.func_77978_p();
        stackCmp.func_218657_a(TAG_MORPH_TOOL_DATA, (INBT)morphData);
        stackCmp.func_74757_a(TAG_MORPHING_TOOL, true);
        if (stack.func_77973_b() != ModItems.tool) {
            String displayName = ITextComponent.Serializer.func_150696_a((ITextComponent)stack.func_200301_q());
            if (stackCmp.func_74764_b(TAG_MORPH_TOOL_DISPLAY_NAME)) {
                displayName = stackCmp.func_74779_i(TAG_MORPH_TOOL_DISPLAY_NAME);
            } else {
                stackCmp.func_74778_a(TAG_MORPH_TOOL_DISPLAY_NAME, displayName);
            }
            ITextComponent stackName = ITextComponent.Serializer.func_150699_a((String)displayName).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
            TranslationTextComponent comp = new TranslationTextComponent("morphtool.sudo_name", new Object[]{stackName});
            stack.func_200302_a((ITextComponent)comp);
        }
        stack.func_190920_e(1);
        return stack;
    }

    public static String getModNameForId(String modId) {
        return modNames.containsKey(modId = modId.toLowerCase(Locale.ENGLISH)) ? modNames.get(modId) : modId;
    }

    public static boolean isMorphTool(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == ModItems.tool) {
            return true;
        }
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_MORPHING_TOOL);
    }

    public static RayTraceResult raycast(Entity e, double len) {
        Vec3d look;
        Vec3d vec = new Vec3d(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
        if (e instanceof PlayerEntity) {
            vec = vec.func_178787_e(new Vec3d(0.0, (double)e.func_70047_e(), 0.0));
        }
        if ((look = e.func_70040_Z()) == null) {
            return null;
        }
        return MorphingHandler.raycast(e, vec, look, len);
    }

    public static RayTraceResult raycast(Entity e, Vec3d origin, Vec3d ray, double len) {
        Vec3d end = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        return e.func_130014_f_().func_217299_a(new RayTraceContext(origin, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, e));
    }

    static {
        for (ModInfo modEntry : ModList.get().getMods()) {
            modNames.put(modEntry.getModId().toLowerCase(Locale.ENGLISH), modEntry.getDisplayName());
        }
    }
}

