/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.DisplayBlockTile;
import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import com.supermartijn642.movingelevators.base.MEBlock;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DisplayBlock
extends MEBlock {
    public static final int BUTTON_COUNT = 3;
    public static final int BUTTON_COUNT_BIG = 7;
    public static final float BUTTON_HEIGHT = 0.125f;

    public DisplayBlock() {
        super("display_block", DisplayBlockTile::new);
    }

    @Override
    protected void onRightClick(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof DisplayBlockTile)) {
            return;
        }
        DisplayBlockTile displayTile = (DisplayBlockTile)tile;
        if (displayTile.getFacing() == facing) {
            double hitHorizontal;
            int displayCat = displayTile.getDisplayCategory();
            double d = hitHorizontal = facing.func_176740_k() == EnumFacing.Axis.Z ? (double)hitX : (double)hitZ;
            if (hitHorizontal > 0.0625 && hitHorizontal < 0.9375) {
                BlockPos inputTilePos = null;
                int button_count = -1;
                int height = -1;
                if (displayCat == 1) {
                    if ((double)hitY > 0.0625 && (double)hitY < 0.9375) {
                        inputTilePos = pos.func_177977_b();
                        button_count = 3;
                        height = 1;
                    }
                } else if (displayCat == 2) {
                    if ((double)hitY > 0.0625) {
                        inputTilePos = pos.func_177977_b();
                        button_count = 7;
                        height = 2;
                    }
                } else if (displayCat == 3 && (double)hitY < 0.9375) {
                    inputTilePos = pos.func_177979_c(2);
                    button_count = 7;
                    height = 2;
                    hitY += 1.0f;
                }
                if (inputTilePos == null) {
                    return;
                }
                tile = worldIn.func_175625_s(inputTilePos);
                if (tile instanceof ElevatorInputTile && ((ElevatorInputTile)tile).hasGroup()) {
                    ElevatorInputTile inputTile = (ElevatorInputTile)tile;
                    List<ElevatorBlockTile> allTiles = inputTile.getGroup().getTiles();
                    int index = inputTile.getGroup().getFloorNumber(inputTile.getFloorLevel());
                    int below = Math.min(index, button_count);
                    int above = Math.min(allTiles.size() - index - 1, button_count + (button_count - below));
                    below = Math.min(below, button_count + (button_count - above));
                    int total = below + 1 + above;
                    int floorOffset = (int)Math.floor(((double)hitY - (double)((float)height - (float)total * 0.125f) / 2.0) / 0.125) - index;
                    if (player == null || player.func_184586_b(handIn).func_190926_b() || !(player.func_184586_b(handIn).func_77973_b() instanceof ItemDye)) {
                        inputTile.getGroup().onDisplayPress(inputTile.getFloorLevel(), floorOffset);
                    } else {
                        int floor;
                        EnumDyeColor color = EnumDyeColor.func_176766_a((int)player.func_184586_b(handIn).func_77960_j());
                        ElevatorGroup group = inputTile.getGroup();
                        ElevatorBlockTile elevatorTile = group.getTileForFloor(floor = group.getFloorNumber(inputTile.getFloorLevel()) + floorOffset);
                        if (elevatorTile != null) {
                            elevatorTile.setDisplayLabelColor(color);
                        }
                    }
                }
            }
        }
    }
}

