/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ClientProxy;
import com.supermartijn642.movingelevators.ElevatorBlock;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ElevatorBlockTile
extends ElevatorInputTile
implements ITickable {
    private ElevatorGroup group;
    private String name;
    private EnumDyeColor color = EnumDyeColor.GRAY;
    private EnumFacing facing;
    public boolean redstone;
    private boolean lastRedstone;

    public void func_73660_a() {
        if (this.facing == null) {
            this.facing = (EnumFacing)this.getBlockState().func_177229_b((IProperty)ElevatorBlock.FACING);
            if (this.group != null && this.group.getLowest() == this.field_174879_c.func_177956_o()) {
                this.group.setFacing(this.facing);
            }
            this.func_70296_d();
        }
        if (this.group != null) {
            if (this.group.getLowest() == this.field_174879_c.func_177956_o()) {
                this.group.update(this);
            }
            if (!this.field_145850_b.field_72995_K && this.lastRedstone != this.redstone) {
                if (this.redstone) {
                    this.group.onButtonPress(false, false, this.field_174879_c.func_177956_o());
                }
                this.lastRedstone = this.redstone;
                this.func_70296_d();
            }
        } else if (!this.field_145850_b.field_72995_K) {
            ArrayList<ElevatorBlockTile> tiles = new ArrayList<ElevatorBlockTile>(1);
            tiles.add(this);
            for (int y = 0; y <= this.field_145850_b.func_72800_K(); ++y) {
                ElevatorBlockTile elevator;
                TileEntity tileEntity;
                if (y == this.field_174879_c.func_177956_o() || !((tileEntity = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p()))) instanceof ElevatorBlockTile) || (elevator = (ElevatorBlockTile)tileEntity).getFacing() != this.getFacing()) continue;
                if (elevator.group == null) {
                    tiles.add(elevator);
                    continue;
                }
                for (ElevatorBlockTile elevator2 : tiles) {
                    elevator.group.add(elevator2);
                }
                return;
            }
            this.group = new ElevatorGroup(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.getFacing());
            for (ElevatorBlockTile elevatorBlockTile : tiles) {
                this.group.add(elevatorBlockTile);
            }
        }
    }

    public boolean hasPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.getFacing().func_82601_c() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.getFacing().func_82599_e() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        for (int x = 0; x < this.group.getSize(); ++x) {
            for (int z = 0; z < this.group.getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos) || this.field_145850_b.func_175625_s(pos) != null) {
                    return false;
                }
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                if (state.func_185887_b(this.field_145850_b, pos) < 0.0f) {
                    return false;
                }
                AxisAlignedBB collisionBox = state.func_185890_d((IBlockAccess)this.field_145850_b, pos);
                if (collisionBox != null && collisionBox.field_72337_e == 1.0 && collisionBox.field_72340_a == 0.0 && collisionBox.field_72336_d == 1.0 && collisionBox.field_72339_c == 0.0 && collisionBox.field_72334_f == 1.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasSpaceForPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.facing.func_82601_c() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.facing.func_82599_e() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        for (int x = 0; x < this.group.getSize(); ++x) {
            for (int z = 0; z < this.group.getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    protected NBTTagCompound getChangedData() {
        return this.getAllData();
    }

    @Override
    protected NBTTagCompound getAllData() {
        NBTTagCompound data = super.getAllData();
        if (this.name != null) {
            data.func_74778_a("name", this.name);
        }
        data.func_74768_a("color", this.color.func_176765_a());
        if (this.facing != null) {
            data.func_74768_a("facing", this.facing.func_176745_a());
        }
        if (this.group != null && this.field_174879_c.func_177956_o() == this.group.getLowest()) {
            data.func_74782_a("group", (NBTBase)this.group.write());
        }
        data.func_74757_a("redstone", this.lastRedstone);
        return data;
    }

    @Override
    protected void handleData(NBTTagCompound tag) {
        super.handleData(tag);
        if (tag.func_74764_b("moving") && tag.func_74767_n("moving")) {
            if (this.group == null) {
                this.group = new ElevatorGroup(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.facing);
            }
            this.group.read(tag);
        }
        String string = this.name = tag.func_74764_b("name") ? tag.func_74779_i("name") : null;
        if (tag.func_74764_b("color")) {
            this.color = EnumDyeColor.func_176764_b((int)tag.func_74762_e("color"));
        }
        if (tag.func_74764_b("facing")) {
            this.facing = EnumFacing.func_82600_a((int)tag.func_74762_e("facing"));
        }
        if (tag.func_74764_b("group")) {
            if (this.group == null) {
                this.group = new ElevatorGroup(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.facing);
            }
            this.group.read(tag.func_74775_l("group"));
        }
        if (tag.func_74764_b("redstone")) {
            this.lastRedstone = this.redstone = tag.func_74767_n("redstone");
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public void onBreak() {
        this.group.remove(this.field_174879_c.func_177956_o());
    }

    public double func_145833_n() {
        return this.field_145850_b.func_72800_K() * this.field_145850_b.func_72800_K() * 4;
    }

    public String getDefaultFloorName() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K || this.group == null || this.field_174879_c == null) {
            return null;
        }
        return ClientProxy.translate("movingelevators.floorname").replace("$number$", Integer.toString(this.group.getFloorNumber(this.field_174879_c.func_177956_o())));
    }

    @Override
    public String getFloorName() {
        return this.name == null ? this.getDefaultFloorName() : this.name;
    }

    public void setFloorName(String name) {
        this.name = name;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 2);
        this.func_70296_d();
    }

    public void setDisplayLabelColor(EnumDyeColor color) {
        this.color = color;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 2);
        this.func_70296_d();
    }

    @Override
    public EnumDyeColor getDisplayLabelColor() {
        return this.color;
    }

    @Override
    public ElevatorGroup getGroup() {
        return this.group;
    }

    public void setGroup(ElevatorGroup group) {
        this.group = group;
    }

    @Override
    public boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public int getFloorLevel() {
        return this.field_174879_c.func_177956_o();
    }
}

