/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.base;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import com.supermartijn642.movingelevators.base.METileRenderer;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class ElevatorInputTileRenderer<T extends ElevatorInputTile>
extends METileRenderer<T> {
    private static final ResourceLocation BUTTONS = ElevatorInputTileRenderer.getTexture("buttons");
    private static final ResourceLocation DISPLAY_BACKGROUND = ElevatorInputTileRenderer.getTexture("display_overlay");
    private static final ResourceLocation DISPLAY_BACKGROUND_BIG = ElevatorInputTileRenderer.getTexture("display_overlay_big");
    private static final ResourceLocation DISPLAY_GREEN_DOT = ElevatorInputTileRenderer.getTexture("green_dot");
    private static final HashMap<EnumDyeColor, ResourceLocation> DISPLAY_BUTTONS = new HashMap();
    private static final HashMap<EnumDyeColor, ResourceLocation> DISPLAY_BUTTONS_OFF = new HashMap();

    private static ResourceLocation getTexture(String name) {
        return new ResourceLocation("movingelevators", "textures/blocks/" + name + ".png");
    }

    @Override
    protected void render() {
        if (!((ElevatorInputTile)this.tile).hasGroup() || ((ElevatorInputTile)this.tile).getFacing() == null) {
            return;
        }
        this.renderButtons();
        this.renderDisplay();
    }

    private void renderButtons() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)this.z);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)(180.0f - ((ElevatorInputTile)this.tile).getFacing().func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.51);
        this.drawQuad(BUTTONS, ((ElevatorInputTile)this.tile).func_174877_v());
        GlStateManager.func_179121_F();
    }

    private void renderDisplay() {
        double platformY;
        ResourceLocation background;
        int button_count;
        int height = ((ElevatorInputTile)this.tile).getDisplayHeight();
        if (height <= 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)this.z);
        GlStateManager.func_179137_b((double)0.5, (double)1.5, (double)0.5);
        GlStateManager.func_179114_b((float)(180.0f - ((ElevatorInputTile)this.tile).getFacing().func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.51);
        if (height == 1) {
            button_count = 3;
            background = DISPLAY_BACKGROUND;
        } else {
            button_count = 7;
            background = DISPLAY_BACKGROUND_BIG;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)height, (float)1.0f);
        this.drawQuad(background, ((ElevatorInputTile)this.tile).func_174877_v().func_177984_a());
        GlStateManager.func_179121_F();
        List<ElevatorBlockTile> allTiles = ((ElevatorInputTile)this.tile).getGroup().getTiles();
        int index = ((ElevatorInputTile)this.tile).getGroup().getFloorNumber(((ElevatorInputTile)this.tile).getFloorLevel());
        int below = Math.min(index, button_count);
        int above = Math.min(allTiles.size() - index - 1, button_count + (button_count - below));
        below = Math.min(below, button_count + (button_count - above));
        int startIndex = index - below;
        int total = below + 1 + above;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)(0.5 * (double)height - (double)((float)total * 0.125f) / 2.0), (double)-0.002);
        GlStateManager.func_179152_a((float)1.0f, (float)0.125f, (float)1.0f);
        for (int i = 0; i < total; ++i) {
            this.drawQuad((startIndex + i == index ? DISPLAY_BUTTONS_OFF : DISPLAY_BUTTONS).get(allTiles.get(startIndex + i).getDisplayLabelColor()), ((ElevatorInputTile)this.tile).func_174877_v().func_177984_a());
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.578125, (double)0.0, (double)0.0);
            this.drawString(allTiles.get(startIndex + i).getFloorName());
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179121_F();
        if (((ElevatorInputTile)this.tile).getGroup().isMoving() && (platformY = ((ElevatorInputTile)this.tile).getGroup().getCurrentY()) >= (double)allTiles.get(0).func_174877_v().func_177956_o() && platformY < (double)allTiles.get(allTiles.size() - 1).func_174877_v().func_177956_o()) {
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < allTiles.size() - 1; ++i) {
                int belowY = allTiles.get(i).func_174877_v().func_177956_o();
                int aboveY = allTiles.get(i + 1).func_174877_v().func_177956_o();
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            GlStateManager.func_179137_b((double)0.078125, (double)yOffset, (double)-0.003);
            GlStateManager.func_179152_a((float)0.125f, (float)0.125f, (float)1.0f);
            this.drawQuad(DISPLAY_GREEN_DOT, ((ElevatorInputTile)this.tile).func_174877_v().func_177984_a());
        }
        GlStateManager.func_179121_F();
    }

    private void drawQuad(ResourceLocation texture, BlockPos pos) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int i = Minecraft.func_71410_x().field_71441_e.func_175626_b(pos.func_177972_a(((ElevatorInputTile)this.tile).getFacing()), 0);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_179140_f();
        GlStateManager.func_179088_q();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179141_d();
        GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        builder.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        builder.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179113_r();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void drawString(String s) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.07, (double)-0.005);
        GlStateManager.func_179152_a((float)-0.01f, (float)-0.08f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179088_q();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
        fontRenderer.func_175063_a(s, (float)(-fontRenderer.func_78256_a(s)) / 2.0f, (float)(-fontRenderer.field_78288_b), EnumDyeColor.WHITE.func_193350_e());
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179113_r();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(T te) {
        return true;
    }

    static {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            DISPLAY_BUTTONS.put(color, ElevatorInputTileRenderer.getTexture("display_buttons/display_button_" + color.name().toLowerCase()));
            DISPLAY_BUTTONS_OFF.put(color, ElevatorInputTileRenderer.getTexture("display_buttons/display_button_off_" + color.name().toLowerCase()));
        }
    }
}

