/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.gui.ElevatorSizeSlider;
import com.supermartijn642.movingelevators.gui.ElevatorSpeedSlider;
import com.supermartijn642.movingelevators.packets.PacketElevatorName;
import com.supermartijn642.movingelevators.packets.PacketElevatorSize;
import com.supermartijn642.movingelevators.packets.PacketElevatorSpeed;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ElevatorScreen
extends GuiScreen {
    private static final int MAX_NAME_CHARACTER_COUNT = 11;
    private BlockPos elevatorPos;
    private GuiTextField nameField;
    private String lastTickName;

    public ElevatorScreen(BlockPos elevatorPos) {
        this.elevatorPos = elevatorPos;
    }

    public void func_73866_w_() {
        ElevatorBlockTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        int width = 150;
        int height = 20;
        BlockPos pos = tile.func_174877_v();
        this.func_189646_b(new ElevatorSizeSlider(this.field_146294_l / 2 - width - 10, this.field_146295_m / 2 - height / 2, width, height, tile.getGroup().getSize(), slider -> MovingElevators.channel.sendToServer((IMessage)new PacketElevatorSize(pos, slider.getValue()))));
        this.func_189646_b(new ElevatorSpeedSlider(this.field_146294_l / 2 + 10, this.field_146295_m / 2 - height / 2, width, height, tile.getGroup().getSpeed(), slider -> MovingElevators.channel.sendToServer((IMessage)new PacketElevatorSpeed(pos, slider.getValue()))));
        this.nameField = new GuiTextField(0, this.field_146289_q, (this.field_146294_l - width) / 2, this.field_146295_m / 13 * 4, width, height);
        this.nameField.func_146180_a(tile.getFloorName());
        this.lastTickName = this.nameField.func_146179_b();
        this.nameField.func_146205_d(true);
        this.nameField.func_146195_b(false);
        this.nameField.func_146203_f(11);
    }

    public void func_73876_c() {
        super.func_73876_c();
        ElevatorBlockTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.nameField.func_146178_a();
        if (!this.lastTickName.equals(this.nameField.func_146179_b())) {
            String name = this.nameField.func_146179_b();
            if (name.isEmpty() ? !tile.getDefaultFloorName().equals(tile.getFloorName()) : !name.equals(tile.getFloorName())) {
                MovingElevators.channel.sendToServer((IMessage)new PacketElevatorName(tile.func_174877_v(), name.isEmpty() || name.equals(tile.getDefaultFloorName()) ? null : name));
            }
            this.lastTickName = name;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private ElevatorBlockTile getTileOrClose() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(this.elevatorPos);
        if (tile instanceof ElevatorBlockTile) {
            return (ElevatorBlockTile)tile;
        }
        player.func_71053_j();
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1 && mouseX >= this.nameField.field_146209_f && mouseX < this.nameField.field_146209_f + this.nameField.field_146218_h && mouseY >= this.nameField.field_146210_g && mouseY < this.nameField.field_146210_g + this.nameField.field_146219_i) {
            this.nameField.func_146180_a("");
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.movingelevators.floorname.label", (Object[])new Object[0]), this.nameField.field_146209_f + 2, this.field_146295_m / 4, Integer.MAX_VALUE);
        this.nameField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        this.nameField.func_146201_a(c, keyCode);
        if (!this.nameField.func_146206_l() && (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode))) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

