/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.FallDamageHandler;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.packets.PacketOnElevator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ElevatorGroup {
    private World world;
    private final int x;
    private final int z;
    private Direction facing;
    private boolean isMoving = false;
    private int targetY;
    private double lastY;
    private double currentY;
    private int size;
    private int nextSize = this.size = 3;
    private double speed;
    private double nextSpeed = this.speed = 0.2;
    private BlockState[][] platform = new BlockState[this.size][this.size];
    private final ArrayList<Integer> floors = new ArrayList();

    public ElevatorGroup(World world, int x, int z, Direction facing) {
        this.world = world;
        this.x = x;
        this.z = z;
        this.facing = facing;
    }

    public void update(ElevatorBlockTile tile) {
        if (this.world == null) {
            this.world = tile.func_145831_w();
        }
        if (this.isMoving) {
            this.lastY = this.currentY;
            if (this.currentY == (double)this.targetY) {
                this.stopElevator();
            } else if (Math.abs((double)this.targetY - this.currentY) < this.speed) {
                this.currentY = this.targetY;
                this.moveElevator(this.lastY, this.currentY);
            } else {
                this.currentY += Math.signum((double)this.targetY - this.currentY) * this.speed;
                this.moveElevator(this.lastY, this.currentY);
            }
        } else if (this.nextSize != this.size || this.nextSpeed != this.speed) {
            this.size = this.nextSize;
            this.speed = this.nextSpeed;
            this.platform = new BlockState[this.size][this.size];
            BlockState state = this.world.func_180495_p(this.getPos(this.getLowest()));
            this.world.func_184138_a(this.getPos(this.getLowest()), state, state, 2);
            this.markDirty();
        }
    }

    private void moveElevator(double oldY, double newY) {
        int x = this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        int z = this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        AxisAlignedBB box = new AxisAlignedBB((double)x, Math.min(oldY, newY), (double)z, (double)(x + this.size), Math.max(oldY, newY) + 1.0 + 3.0 * this.speed, (double)(z + this.size));
        List entities = this.world.func_217394_a((EntityType)null, box, this::canCollideWith);
        for (Entity entity : entities) {
            if (newY < oldY && entity.func_189652_ae() || entity instanceof PlayerEntity && entity.func_213322_ci().field_72448_b >= 0.0 && entity.field_70163_u > Math.min(oldY, newY) + 1.0) continue;
            entity.func_70107_b(entity.field_70165_t, newY + 1.0, entity.field_70161_v);
            entity.field_70122_E = true;
            entity.func_180430_e(entity.field_70143_R, 1.0f);
            entity.field_70143_R = 0.0f;
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
            if (!(entity instanceof PlayerEntity)) continue;
            FallDamageHandler.resetElevatorTime((PlayerEntity)entity);
            if (!this.world.field_72995_K) continue;
            MovingElevators.CHANNEL.sendToServer((Object)new PacketOnElevator());
        }
        if (!this.world.field_72995_K) {
            this.markDirty();
        }
    }

    private boolean canCollideWith(Entity entity) {
        return !entity.func_175149_v() && !entity.field_70145_X && entity.func_184192_z() == PushReaction.NORMAL;
    }

    private void stopElevator() {
        this.isMoving = false;
        int startX = this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        int startZ = this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                BlockPos pos = new BlockPos(startX + x, this.targetY, startZ + z);
                if (!this.world.func_175623_d(pos)) {
                    this.world.func_175655_b(pos, true);
                }
                this.world.func_175656_a(pos, this.platform[x][z]);
            }
        }
        AxisAlignedBB box = new AxisAlignedBB((double)startX, this.currentY, (double)startZ, (double)(startX + this.size), this.currentY + 1.0, (double)(startZ + this.size));
        List entities = this.world.func_217394_a((EntityType)null, box, this::canCollideWith);
        for (Entity entity : entities) {
            entity.func_70634_a(entity.field_70165_t, this.currentY + 1.0, entity.field_70161_v);
            entity.field_70122_E = true;
            entity.field_70143_R = 0.0f;
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
        }
        if (!this.world.field_72995_K) {
            BlockState state = this.world.func_180495_p(this.getPos(this.getLowest()));
            this.world.func_184138_a(this.getPos(this.getLowest()), state, state, 2);
            this.world.func_175666_e(this.getPos(this.targetY + 1), (Block)MovingElevators.elevator_block);
            this.markDirty();
            double x = (double)(this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f)) + 0.5;
            double z = (double)(this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f)) + 0.5;
            this.world.func_184148_a(null, x, (double)this.targetY + 2.5, z, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.4f, 0.5f);
        }
    }

    private void startElevator(int currentY, int targetY) {
        int z;
        int x;
        if (this.world == null || this.isMoving) {
            return;
        }
        int startX = this.x + this.facing.func_82601_c() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        int startZ = this.z + this.facing.func_82599_e() * (int)Math.ceil((float)this.size / 2.0f) - this.size / 2;
        for (x = 0; x < this.size; ++x) {
            for (z = 0; z < this.size; ++z) {
                BlockPos pos = new BlockPos(startX + x, currentY - 1, startZ + z);
                if (this.world.func_175623_d(pos) || this.world.func_175625_s(pos) != null) {
                    return;
                }
                BlockState state = this.world.func_180495_p(pos);
                if (state.func_185887_b((IBlockReader)this.world, pos) < 0.0f) {
                    return;
                }
                if (state.func_196954_c((IBlockReader)this.world, pos).func_197758_c(Direction.Axis.Y) != 1.0 || state.func_196954_c((IBlockReader)this.world, pos).func_197762_b(Direction.Axis.X) != 0.0 || state.func_196954_c((IBlockReader)this.world, pos).func_197758_c(Direction.Axis.X) != 1.0 || state.func_196954_c((IBlockReader)this.world, pos).func_197762_b(Direction.Axis.Z) != 0.0 || state.func_196954_c((IBlockReader)this.world, pos).func_197758_c(Direction.Axis.Z) != 1.0) {
                    return;
                }
                this.platform[x][z] = state;
            }
        }
        for (x = 0; x < this.size; ++x) {
            for (z = 0; z < this.size; ++z) {
                this.world.func_175656_a(new BlockPos(startX + x, currentY - 1, startZ + z), Blocks.field_150350_a.func_176223_P());
            }
        }
        this.isMoving = true;
        this.targetY = targetY - 1;
        this.lastY = this.currentY = (double)(currentY - 1);
        if (!this.world.field_72995_K) {
            BlockState state = this.world.func_180495_p(this.getPos(this.getLowest()));
            this.world.func_184138_a(this.getPos(this.getLowest()), state, state, 2);
            this.world.func_175666_e(this.getPos(currentY), (Block)MovingElevators.elevator_block);
            this.markDirty();
        }
    }

    public void onButtonPress(boolean isUp, boolean isDown, int yLevel) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        ElevatorBlockTile tile = this.getTile(yLevel);
        if (tile == null) {
            return;
        }
        if (isUp) {
            if (tile.hasPlatform()) {
                for (int floor = this.floors.indexOf(yLevel) + 1; floor < this.floors.size(); ++floor) {
                    ElevatorBlockTile tile2 = this.getTile(this.floors.get(floor));
                    if (tile2 == null) continue;
                    if (tile2.hasSpaceForPlatform()) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (isDown) {
            if (tile.hasPlatform()) {
                for (int floor = this.floors.indexOf(yLevel) - 1; floor >= 0; --floor) {
                    ElevatorBlockTile tile2 = this.getTile(this.floors.get(floor));
                    if (tile2 == null) continue;
                    if (tile2.hasSpaceForPlatform()) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (tile.hasSpaceForPlatform()) {
            this.floors.sort(Comparator.comparingInt(a -> Math.abs(a - yLevel)));
            for (int y : this.floors) {
                ElevatorBlockTile tile2;
                if (y == yLevel || (tile2 = this.getTile(y)) == null || !tile2.hasPlatform()) continue;
                this.floors.sort(Integer::compare);
                this.startElevator(y, yLevel);
                return;
            }
            this.floors.sort(Integer::compare);
        }
    }

    public void onDisplayPress(int yLevel, int floorOffset) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        int floor = this.floors.indexOf(yLevel);
        if (floorOffset == 0) {
            this.onButtonPress(false, false, yLevel);
            return;
        }
        int toFloor = floor + floorOffset;
        if (toFloor < 0 || toFloor >= this.floors.size()) {
            return;
        }
        ElevatorBlockTile tile = this.getTile(yLevel);
        int toY = this.floors.get(toFloor);
        ElevatorBlockTile toTile = this.getTile(toY);
        if (tile != null && toTile != null && tile.hasPlatform() && toTile.hasSpaceForPlatform()) {
            this.startElevator(yLevel, toY);
        }
    }

    public void remove(int y) {
        this.floors.remove((Object)y);
        if (this.floors.isEmpty()) {
            if (this.isMoving) {
                BlockPos spawnPos = this.getPos(y).func_177967_a(this.facing, this.size / 2 + 1);
                BlockState[][] blockStateArray = this.platform;
                int n = blockStateArray.length;
                for (int i = 0; i < n; ++i) {
                    BlockState[] arr;
                    for (BlockState state : arr = blockStateArray[i]) {
                        ItemEntity entity = new ItemEntity(this.world, (double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)state.func_177230_c()));
                        this.world.func_217376_c((Entity)entity);
                    }
                }
            }
        } else if (!this.world.field_72995_K) {
            BlockState state = this.world.func_180495_p(this.getPos(this.getLowest()));
            this.world.func_184138_a(this.getPos(this.getLowest()), state, state, 2);
            this.markDirty();
        }
    }

    public void add(ElevatorBlockTile tile) {
        if (tile == null) {
            return;
        }
        if (this.world == null) {
            this.world = tile.func_145831_w();
        }
        tile.setGroup(this);
        int y = tile.func_174877_v().func_177956_o();
        if (this.floors.contains(y)) {
            return;
        }
        if (this.floors.isEmpty()) {
            this.floors.add(y);
        }
        for (int i = 0; i < this.floors.size(); ++i) {
            if (y >= this.floors.get(i)) continue;
            this.floors.add(i, y);
            break;
        }
        if (!this.floors.contains(y)) {
            this.floors.add(y);
        }
        if (!this.world.field_72995_K) {
            BlockState state = this.world.func_180495_p(this.getPos(this.getLowest()));
            this.world.func_184138_a(this.getPos(this.getLowest()), state, state, 2);
            this.markDirty();
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public double getLastY() {
        return this.lastY;
    }

    public double getCurrentY() {
        return this.currentY;
    }

    public BlockState[][] getPlatform() {
        return this.platform;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.nextSize = size;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.nextSpeed = speed;
    }

    public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("moving", this.isMoving);
        tag.func_74768_a("size", this.size);
        if (this.isMoving) {
            tag.func_74768_a("targetY", this.targetY);
            tag.func_74780_a("lastY", this.lastY);
            tag.func_74780_a("currentY", this.currentY);
            for (int x = 0; x < this.size; ++x) {
                for (int z = 0; z < this.size; ++z) {
                    tag.func_74768_a("platform" + x + "," + z, Block.func_196246_j((BlockState)this.platform[x][z]));
                }
            }
        }
        tag.func_74780_a("speed", this.speed);
        tag.func_197646_b("floors", this.floors);
        return tag;
    }

    public void read(CompoundNBT tag) {
        if (tag.func_74764_b("moving")) {
            this.isMoving = tag.func_74767_n("moving");
        }
        if (tag.func_74764_b("targetY")) {
            this.targetY = tag.func_74762_e("targetY");
        }
        if (tag.func_74764_b("lastY")) {
            this.lastY = tag.func_74769_h("lastY");
        }
        if (tag.func_74764_b("currentY")) {
            this.currentY = tag.func_74769_h("currentY");
        }
        if (tag.func_74764_b("size")) {
            this.nextSize = this.size = tag.func_74762_e("size");
            this.platform = new BlockState[this.size][this.size];
        }
        if (tag.func_74764_b("speed")) {
            this.nextSpeed = this.speed = tag.func_74769_h("speed");
        }
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.platform[x][z] = Block.func_196257_b((int)tag.func_74762_e("platform" + x + "," + z));
            }
        }
        if (tag.func_74764_b("floors")) {
            this.floors.clear();
            for (int y : tag.func_74759_k("floors")) {
                this.floors.add(y);
                ElevatorBlockTile tile = this.getTile(y);
                if (tile == null) continue;
                tile.setGroup(this);
            }
        }
    }

    private BlockPos getPos(int y) {
        return new BlockPos(this.x, y, this.z);
    }

    private ElevatorBlockTile getTile(int y) {
        if (this.world == null) {
            return null;
        }
        TileEntity tile = this.world.func_175625_s(this.getPos(y));
        return tile instanceof ElevatorBlockTile ? (ElevatorBlockTile)tile : null;
    }

    public int getLowest() {
        return this.floors.get(0);
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
    }

    public List<ElevatorBlockTile> getTiles() {
        ArrayList<ElevatorBlockTile> tiles = new ArrayList<ElevatorBlockTile>(this.floors.size());
        for (int y : this.floors) {
            ElevatorBlockTile tile = this.getTile(y);
            if (tile == null) continue;
            tiles.add(tile);
        }
        return tiles;
    }

    public int getFloorNumber(int y) {
        return this.floors.indexOf(y);
    }

    public ElevatorBlockTile getTileForFloor(int floor) {
        if (floor < 0 || floor >= this.floors.size()) {
            return null;
        }
        return this.getTile(this.floors.get(floor));
    }

    private void markDirty() {
        ElevatorBlockTile tile = this.getTile(this.getLowest());
        if (tile != null) {
            tile.func_70296_d();
        }
    }
}

