/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.base;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import com.supermartijn642.movingelevators.base.METileRenderer;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class ElevatorInputTileRenderer<T extends ElevatorInputTile>
extends METileRenderer<T> {
    private static final ResourceLocation BUTTONS = ElevatorInputTileRenderer.getTexture("buttons");
    private static final ResourceLocation DISPLAY_BACKGROUND = ElevatorInputTileRenderer.getTexture("display_overlay");
    private static final ResourceLocation DISPLAY_BACKGROUND_BIG = ElevatorInputTileRenderer.getTexture("display_overlay_big");
    private static final ResourceLocation DISPLAY_GREEN_DOT = ElevatorInputTileRenderer.getTexture("green_dot");
    private static final HashMap<DyeColor, ResourceLocation> DISPLAY_BUTTONS = new HashMap();
    private static final HashMap<DyeColor, ResourceLocation> DISPLAY_BUTTONS_OFF = new HashMap();

    private static ResourceLocation getTexture(String name) {
        return new ResourceLocation("movingelevators", "textures/blocks/" + name + ".png");
    }

    @Override
    protected void render() {
        if (!((ElevatorInputTile)this.tile).hasGroup() || ((ElevatorInputTile)this.tile).getFacing() == null) {
            return;
        }
        this.renderButtons();
        this.renderDisplay();
    }

    private void renderButtons() {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)this.x, (double)this.y, (double)this.z);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.rotated((double)(180.0f - ((ElevatorInputTile)this.tile).getFacing().func_185119_l()), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.51);
        this.drawQuad(BUTTONS, ((ElevatorInputTile)this.tile).func_174877_v());
        GlStateManager.popMatrix();
    }

    private void renderDisplay() {
        double platformY;
        ResourceLocation background;
        int button_count;
        int height = ((ElevatorInputTile)this.tile).getDisplayHeight();
        if (height <= 0) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)this.x, (double)this.y, (double)this.z);
        GlStateManager.translated((double)0.5, (double)1.5, (double)0.5);
        GlStateManager.rotated((double)(180.0f - ((ElevatorInputTile)this.tile).getFacing().func_185119_l()), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.51);
        if (height == 1) {
            button_count = 3;
            background = DISPLAY_BACKGROUND;
        } else {
            button_count = 7;
            background = DISPLAY_BACKGROUND_BIG;
        }
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)1.0f, (float)height, (float)1.0f);
        this.drawQuad(background, ((ElevatorInputTile)this.tile).func_174877_v().func_177984_a());
        GlStateManager.popMatrix();
        List<ElevatorBlockTile> allTiles = ((ElevatorInputTile)this.tile).getGroup().getTiles();
        int index = ((ElevatorInputTile)this.tile).getGroup().getFloorNumber(((ElevatorInputTile)this.tile).getFloorLevel());
        int below = Math.min(index, button_count);
        int above = Math.min(allTiles.size() - index - 1, button_count + (button_count - below));
        below = Math.min(below, button_count + (button_count - above));
        int startIndex = index - below;
        int total = below + 1 + above;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)(0.5 * (double)height - (double)((float)total * 0.125f) / 2.0), (double)-0.002);
        GlStateManager.scaled((double)1.0, (double)0.125, (double)1.0);
        for (int i = 0; i < total; ++i) {
            this.drawQuad((startIndex + i == index ? DISPLAY_BUTTONS_OFF : DISPLAY_BUTTONS).get(allTiles.get(startIndex + i).getDisplayLabelColor()), ((ElevatorInputTile)this.tile).func_174877_v().func_177984_a());
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.578125, (double)0.0, (double)0.0);
            this.drawString(allTiles.get(startIndex + i).getFloorName());
            GlStateManager.popMatrix();
            GlStateManager.translated((double)0.0, (double)1.0, (double)0.0);
        }
        GlStateManager.popMatrix();
        if (((ElevatorInputTile)this.tile).getGroup().isMoving() && (platformY = ((ElevatorInputTile)this.tile).getGroup().getCurrentY()) >= (double)allTiles.get(0).func_174877_v().func_177956_o() && platformY < (double)allTiles.get(allTiles.size() - 1).func_174877_v().func_177956_o()) {
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < allTiles.size() - 1; ++i) {
                int belowY = allTiles.get(i).func_174877_v().func_177956_o();
                int aboveY = allTiles.get(i + 1).func_174877_v().func_177956_o();
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            GlStateManager.translated((double)0.078125, (double)yOffset, (double)-0.003);
            GlStateManager.scalef((float)0.125f, (float)0.125f, (float)1.0f);
            this.drawQuad(DISPLAY_GREEN_DOT, ((ElevatorInputTile)this.tile).func_174877_v().func_177984_a());
        }
        GlStateManager.popMatrix();
    }

    private void drawQuad(ResourceLocation texture, BlockPos pos) {
        GlStateManager.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int i = Minecraft.func_71410_x().field_71441_e.func_217338_b(pos.func_177972_a(((ElevatorInputTile)this.tile).getFacing()), 0);
        int j = i % 65536;
        int k = i / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.disableLighting();
        GlStateManager.enablePolygonOffset();
        GlStateManager.polygonOffset((float)-1.0f, (float)-1.0f);
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        builder.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        builder.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    private void drawString(String s) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.07, (double)-0.005);
        GlStateManager.scalef((float)-0.01f, (float)-0.08f, (float)1.0f);
        GlStateManager.disableLighting();
        GlStateManager.enablePolygonOffset();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.polygonOffset((float)-1.0f, (float)-1.0f);
        float f = (float)(-fontRenderer.func_78256_a(s)) / 2.0f;
        fontRenderer.getClass();
        fontRenderer.func_175063_a(s, f, (float)(-9), DyeColor.WHITE.func_218388_g());
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    public boolean isGlobalRenderer(T te) {
        return true;
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            DISPLAY_BUTTONS.put(color, ElevatorInputTileRenderer.getTexture("display_buttons/display_button_" + color.name().toLowerCase()));
            DISPLAY_BUTTONS_OFF.put(color, ElevatorInputTileRenderer.getTexture("display_buttons/display_button_off_" + color.name().toLowerCase()));
        }
    }
}

