/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.DisplayBlockTile;
import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import com.supermartijn642.movingelevators.base.MEBlock;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class DisplayBlock
extends MEBlock {
    public static final int BUTTON_COUNT = 3;
    public static final int BUTTON_COUNT_BIG = 7;
    public static final float BUTTON_HEIGHT = 0.125f;

    public DisplayBlock() {
        super("display_block", DisplayBlockTile::new);
    }

    @Override
    protected void onRightClick(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult rayTraceResult) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof DisplayBlockTile)) {
            return;
        }
        DisplayBlockTile displayTile = (DisplayBlockTile)tile;
        if (displayTile.getFacing() == rayTraceResult.func_216354_b()) {
            int displayCat = displayTile.getDisplayCategory();
            Vec3d hitVec = rayTraceResult.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            double hitHorizontal = rayTraceResult.func_216354_b().func_176740_k() == Direction.Axis.Z ? hitVec.field_72450_a : hitVec.field_72449_c;
            double hitY = hitVec.field_72448_b;
            if (hitHorizontal > 0.0625 && hitHorizontal < 0.9375) {
                BlockPos inputTilePos = null;
                int button_count = -1;
                int height = -1;
                if (displayCat == 1) {
                    if (hitY > 0.0625 && hitY < 0.9375) {
                        inputTilePos = pos.func_177977_b();
                        button_count = 3;
                        height = 1;
                    }
                } else if (displayCat == 2) {
                    if (hitY > 0.0625) {
                        inputTilePos = pos.func_177977_b();
                        button_count = 7;
                        height = 2;
                    }
                } else if (displayCat == 3 && hitY < 0.9375) {
                    inputTilePos = pos.func_177979_c(2);
                    button_count = 7;
                    height = 2;
                    hitY += 1.0;
                }
                if (inputTilePos == null) {
                    return;
                }
                tile = worldIn.func_175625_s(inputTilePos);
                if (tile instanceof ElevatorInputTile && ((ElevatorInputTile)tile).hasGroup()) {
                    ElevatorInputTile inputTile = (ElevatorInputTile)tile;
                    List<ElevatorBlockTile> allTiles = inputTile.getGroup().getTiles();
                    int index = inputTile.getGroup().getFloorNumber(inputTile.getFloorLevel());
                    int below = Math.min(index, button_count);
                    int above = Math.min(allTiles.size() - index - 1, button_count + (button_count - below));
                    below = Math.min(below, button_count + (button_count - above));
                    int total = below + 1 + above;
                    int floorOffset = (int)Math.floor((hitY - (double)((float)height - (float)total * 0.125f) / 2.0) / 0.125) - index;
                    if (player == null || player.func_184586_b(handIn).func_190926_b() || !(player.func_184586_b(handIn).func_77973_b() instanceof DyeItem)) {
                        inputTile.getGroup().onDisplayPress(inputTile.getFloorLevel(), floorOffset);
                    } else {
                        int floor;
                        DyeColor color = ((DyeItem)player.func_184586_b(handIn).func_77973_b()).func_195962_g();
                        ElevatorGroup group = inputTile.getGroup();
                        ElevatorBlockTile elevatorTile = group.getTileForFloor(floor = group.getFloorNumber(inputTile.getFloorLevel()) + floorOffset);
                        if (elevatorTile != null) {
                            elevatorTile.setDisplayLabelColor(color);
                        }
                    }
                }
            }
        }
    }
}

