/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.google.gson.JsonParseException;
import com.supermartijn642.movingelevators.ClientProxy;
import com.supermartijn642.movingelevators.ElevatorBlock;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.base.ElevatorInputTile;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class ElevatorBlockTile
extends ElevatorInputTile
implements ITickableTileEntity {
    private ElevatorGroup group;
    private String name;
    private DyeColor color = DyeColor.GRAY;
    private Direction facing;
    public boolean redstone;
    private boolean lastRedstone;

    public ElevatorBlockTile() {
        super(MovingElevators.elevator_tile);
    }

    public void func_73660_a() {
        if (this.facing == null) {
            this.facing = (Direction)this.func_195044_w().func_177229_b((IProperty)ElevatorBlock.FACING);
            if (this.group != null && this.group.getLowest() == this.field_174879_c.func_177956_o()) {
                this.group.setFacing(this.facing);
            }
            this.func_70296_d();
        }
        if (this.group != null) {
            if (this.group.getLowest() == this.field_174879_c.func_177956_o()) {
                this.group.update(this);
            }
            if (!this.field_145850_b.field_72995_K && this.lastRedstone != this.redstone) {
                if (this.redstone) {
                    this.group.onButtonPress(false, false, this.field_174879_c.func_177956_o());
                }
                this.lastRedstone = this.redstone;
                this.func_70296_d();
            }
        } else if (!this.field_145850_b.field_72995_K) {
            ArrayList<ElevatorBlockTile> tiles = new ArrayList<ElevatorBlockTile>(1);
            tiles.add(this);
            for (int y = 0; y <= this.field_145850_b.getMaxHeight(); ++y) {
                ElevatorBlockTile elevator;
                TileEntity tileEntity;
                if (y == this.field_174879_c.func_177956_o() || !((tileEntity = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p()))) instanceof ElevatorBlockTile) || (elevator = (ElevatorBlockTile)tileEntity).getFacing() != this.getFacing()) continue;
                if (elevator.group == null) {
                    tiles.add(elevator);
                    continue;
                }
                for (ElevatorBlockTile elevator2 : tiles) {
                    elevator.group.add(elevator2);
                }
                return;
            }
            this.group = new ElevatorGroup(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.getFacing());
            for (ElevatorBlockTile elevatorBlockTile : tiles) {
                this.group.add(elevatorBlockTile);
            }
        }
    }

    public boolean hasPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.getFacing().func_82601_c() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.getFacing().func_82599_e() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        for (int x = 0; x < this.group.getSize(); ++x) {
            for (int z = 0; z < this.group.getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos) || this.field_145850_b.func_175625_s(pos) != null) {
                    return false;
                }
                BlockState state = this.field_145850_b.func_180495_p(pos);
                if (state.func_185887_b((IBlockReader)this.field_145850_b, pos) < 0.0f) {
                    return false;
                }
                if (state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197758_c(Direction.Axis.Y) == 1.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197762_b(Direction.Axis.X) == 0.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197758_c(Direction.Axis.X) == 1.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197762_b(Direction.Axis.Z) == 0.0 && state.func_196954_c((IBlockReader)this.field_145850_b, pos).func_197758_c(Direction.Axis.Z) == 1.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasSpaceForPlatform() {
        int startX = this.field_174879_c.func_177958_n() + this.facing.func_82601_c() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        int startZ = this.field_174879_c.func_177952_p() + this.facing.func_82599_e() * (int)Math.ceil((float)this.group.getSize() / 2.0f) - this.group.getSize() / 2;
        for (int x = 0; x < this.group.getSize(); ++x) {
            for (int z = 0; z < this.group.getSize(); ++z) {
                BlockPos pos = new BlockPos(startX + x, this.field_174879_c.func_177956_o() - 1, startZ + z);
                if (this.field_145850_b.func_175623_d(pos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Direction getFacing() {
        return this.facing;
    }

    @Override
    protected CompoundNBT getChangedData() {
        return this.getAllData();
    }

    @Override
    protected CompoundNBT getAllData() {
        CompoundNBT data = super.getAllData();
        if (this.name != null) {
            data.func_74778_a("name", ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(this.name)));
        }
        data.func_74768_a("color", this.color.func_196059_a());
        if (this.facing != null) {
            data.func_74768_a("facing", this.facing.func_176745_a());
        }
        if (this.group != null && this.field_174879_c.func_177956_o() == this.group.getLowest()) {
            data.func_218657_a("group", (INBT)this.group.write());
        }
        data.func_74757_a("redstone", this.lastRedstone);
        return data;
    }

    @Override
    protected void handleData(CompoundNBT data) {
        super.handleData(data);
        if (data.func_74764_b("moving") && data.func_74767_n("moving")) {
            if (this.group == null) {
                this.group = new ElevatorGroup(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.facing);
            }
            this.group.read(data);
        }
        if (data.func_74764_b("name")) {
            try {
                this.name = ITextComponent.Serializer.func_150699_a((String)data.func_74779_i("name")).func_150254_d();
            }
            catch (JsonParseException ignore) {
                this.name = data.func_74779_i("name");
            }
        } else {
            this.name = null;
        }
        if (data.func_74764_b("color")) {
            this.color = DyeColor.func_196056_a((int)data.func_74762_e("color"));
        }
        if (data.func_74764_b("facing")) {
            this.facing = Direction.func_82600_a((int)data.func_74762_e("facing"));
        }
        if (data.func_74764_b("group")) {
            if (this.group == null) {
                this.group = new ElevatorGroup(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p(), this.facing);
            }
            this.group.read(data.func_74775_l("group"));
        }
        if (data.func_74764_b("redstone")) {
            this.lastRedstone = this.redstone = data.func_74767_n("redstone");
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public void onBreak() {
        this.group.remove(this.field_174879_c.func_177956_o());
    }

    public double func_145833_n() {
        return this.field_145850_b.getMaxHeight() * this.field_145850_b.getMaxHeight() * 4;
    }

    public String getDefaultFloorName() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K || this.group == null || this.field_174879_c == null) {
            return null;
        }
        return ClientProxy.translate("movingelevators.floorname").replace("$number$", Integer.toString(this.group.getFloorNumber(this.field_174879_c.func_177956_o())));
    }

    @Override
    public String getFloorName() {
        return this.name == null ? this.getDefaultFloorName() : this.name;
    }

    public void setFloorName(String name) {
        this.name = name;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        this.func_70296_d();
    }

    public void setDisplayLabelColor(DyeColor color) {
        this.color = color;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        this.func_70296_d();
    }

    @Override
    public DyeColor getDisplayLabelColor() {
        return this.color;
    }

    @Override
    public ElevatorGroup getGroup() {
        return this.group;
    }

    public void setGroup(ElevatorGroup group) {
        this.group = group;
    }

    @Override
    public boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public int getFloorLevel() {
        return this.field_174879_c.func_177956_o();
    }
}

