/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.gui.ElevatorSizeSlider;
import com.supermartijn642.movingelevators.gui.ElevatorSpeedSlider;
import com.supermartijn642.movingelevators.packets.PacketElevatorName;
import com.supermartijn642.movingelevators.packets.PacketElevatorSize;
import com.supermartijn642.movingelevators.packets.PacketElevatorSpeed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class ElevatorScreen
extends Screen {
    private static final int MAX_NAME_CHARACTER_COUNT = 11;
    private BlockPos elevatorPos;
    private Slider sizeSlider;
    private Slider speedSlider;
    private TextFieldWidget nameField;
    private String lastTickName;

    public ElevatorScreen(BlockPos elevatorPos) {
        super((ITextComponent)new TranslationTextComponent("gui.movingelevators.title", new Object[0]));
        this.elevatorPos = elevatorPos;
    }

    protected void init() {
        ElevatorBlockTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        int width = 150;
        int height = 20;
        BlockPos pos = tile.func_174877_v();
        this.sizeSlider = (Slider)this.addButton((Widget)new ElevatorSizeSlider(this.width / 2 - width - 10, this.height / 2 - height / 2, width, height, tile.getGroup().getSize(), slider -> MovingElevators.CHANNEL.sendToServer((Object)new PacketElevatorSize(pos, slider.getValueInt()))));
        this.speedSlider = (Slider)this.addButton((Widget)new ElevatorSpeedSlider(this.width / 2 + 10, this.height / 2 - height / 2, width, height, tile.getGroup().getSpeed(), slider -> MovingElevators.CHANNEL.sendToServer((Object)new PacketElevatorSpeed(pos, slider.getValue()))));
        this.nameField = new TextFieldWidget(this.font, (this.width - width) / 2, this.height / 13 * 4, width, height, "");
        this.children.add(this.nameField);
        this.nameField.func_146180_a(tile.getFloorName());
        this.lastTickName = this.nameField.func_146179_b();
        this.nameField.func_146205_d(true);
        this.nameField.func_146195_b(false);
        this.nameField.func_146203_f(11);
    }

    public void tick() {
        ElevatorBlockTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.nameField.func_146178_a();
        if (!this.lastTickName.equals(this.nameField.func_146179_b())) {
            String name = this.nameField.func_146179_b();
            if (name.isEmpty() ? !tile.getDefaultFloorName().equals(tile.getFloorName()) : !name.equals(tile.getFloorName())) {
                MovingElevators.CHANNEL.sendToServer((Object)new PacketElevatorName(tile.func_174877_v(), name.isEmpty() || name.equals(tile.getDefaultFloorName()) ? null : name));
            }
            this.lastTickName = name;
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.font.func_211126_b(I18n.func_135052_a((String)"gui.movingelevators.floorname.label", (Object[])new Object[0]), (float)(this.nameField.x + 2), (float)this.height / 4.0f, Integer.MAX_VALUE);
        this.nameField.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private ElevatorBlockTile getTileOrClose() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(this.elevatorPos);
        if (tile instanceof ElevatorBlockTile) {
            return (ElevatorBlockTile)tile;
        }
        player.func_71053_j();
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && mouseX >= (double)this.nameField.x && mouseX < (double)(this.nameField.x + this.nameField.getWidth()) && mouseY >= (double)this.nameField.y && mouseY < (double)(this.nameField.y + this.nameField.getHeight())) {
            this.nameField.func_146180_a("");
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (!this.nameField.isFocused() && (p_keyPressed_1_ == 256 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey))) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.sizeSlider.onRelease(mouseX, mouseY);
            this.speedSlider.onRelease(mouseX, mouseY);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }
}

