/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.gui.ElevatorSizeSlider;
import com.supermartijn642.movingelevators.gui.ElevatorSpeedSlider;
import com.supermartijn642.movingelevators.packets.PacketElevatorName;
import com.supermartijn642.movingelevators.packets.PacketElevatorSize;
import com.supermartijn642.movingelevators.packets.PacketElevatorSpeed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class ElevatorScreen
extends Screen {
    private static final int MAX_NAME_CHARACTER_COUNT = 11;
    private BlockPos elevatorPos;
    private Slider sizeSlider;
    private Slider speedSlider;
    private TextFieldWidget nameField;
    private String lastTickName;

    public ElevatorScreen(BlockPos elevatorPos) {
        super((ITextComponent)new TranslationTextComponent("gui.movingelevators.title"));
        this.elevatorPos = elevatorPos;
    }

    protected void func_231160_c_() {
        ElevatorBlockTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        int width = 150;
        int height = 20;
        BlockPos pos = tile.func_174877_v();
        this.sizeSlider = (Slider)this.func_230480_a_((Widget)new ElevatorSizeSlider(this.field_230708_k_ / 2 - width - 10, this.field_230709_l_ / 2 - height / 2, width, height, tile.getGroup().getSize(), slider -> MovingElevators.CHANNEL.sendToServer((Object)new PacketElevatorSize(pos, slider.getValueInt()))));
        this.speedSlider = (Slider)this.func_230480_a_((Widget)new ElevatorSpeedSlider(this.field_230708_k_ / 2 + 10, this.field_230709_l_ / 2 - height / 2, width, height, tile.getGroup().getSpeed(), slider -> MovingElevators.CHANNEL.sendToServer((Object)new PacketElevatorSpeed(pos, slider.getValue()))));
        this.nameField = new TextFieldWidget(this.field_230712_o_, (this.field_230708_k_ - width) / 2, this.field_230709_l_ / 13 * 4, width, height, (ITextComponent)new StringTextComponent(""));
        this.field_230705_e_.add(this.nameField);
        this.nameField.func_146180_a(tile.getFloorName());
        this.lastTickName = this.nameField.func_146179_b();
        this.nameField.func_146205_d(true);
        this.nameField.func_146195_b(false);
        this.nameField.func_146203_f(11);
    }

    public void func_231023_e_() {
        ElevatorBlockTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.nameField.func_146178_a();
        if (!this.lastTickName.equals(this.nameField.func_146179_b())) {
            String name = this.nameField.func_146179_b();
            if (name.isEmpty() ? !tile.getDefaultFloorName().equals(tile.getFloorName()) : !name.equals(tile.getFloorName())) {
                MovingElevators.CHANNEL.sendToServer((Object)new PacketElevatorName(tile.func_174877_v(), name.isEmpty() || name.equals(tile.getDefaultFloorName()) ? null : name));
            }
            this.lastTickName = name;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"gui.movingelevators.floorname.label", (Object[])new Object[0]), (float)(this.nameField.field_230690_l_ + 2), (float)this.field_230709_l_ / 4.0f, Integer.MAX_VALUE);
        this.nameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private ElevatorBlockTile getTileOrClose() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(this.elevatorPos);
        if (tile instanceof ElevatorBlockTile) {
            return (ElevatorBlockTile)tile;
        }
        player.func_71053_j();
        return null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && mouseX >= (double)this.nameField.field_230690_l_ && mouseX < (double)(this.nameField.field_230690_l_ + this.nameField.func_230998_h_()) && mouseY >= (double)this.nameField.field_230691_m_ && mouseY < (double)(this.nameField.field_230691_m_ + this.nameField.getHeight())) {
            this.nameField.func_146180_a("");
        }
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (!this.nameField.func_230999_j_() && (p_keyPressed_1_ == 256 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey))) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.sizeSlider.func_231000_a__(mouseX, mouseY);
            this.speedSlider.func_231000_a__(mouseX, mouseY);
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }
}

