/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.utils;

import com.google.common.collect.Lists;
import io.github.zekerzhayard.optiforge.asm.utils.RedirectSurrogate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public class ASMUtils {
    public static void replaceRedirectSurrogateMethod(ClassNode cn, String mixinClassName) {
        cn.methods.forEach(mn -> Stream.of(mn.instructions.toArray()).filter(ain -> ain.getOpcode() == 183 || ain.getOpcode() == 184).map(ain -> (MethodInsnNode)ain).filter(min -> ASMUtils.isMixinMethodNodeInTargetClass(cn, min.name, min.desc, mixinClassName)).forEach(min -> ASMUtils.findFirstOverLoadMethod(cn, min.name, min.desc, mixinClassName).ifPresent(redirectSurrogateMethod -> {
            InsnList il = ASMUtils.createRedirectSurrogateVarInsnList(mn, redirectSurrogateMethod, min.desc);
            mn.instructions.insertBefore((AbstractInsnNode)min, il);
            mn.instructions.set((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(min.getOpcode(), min.owner, redirectSurrogateMethod.name, redirectSurrogateMethod.desc));
        })));
    }

    public static Optional<MethodNode> findFirstOverLoadMethod(ClassNode classNode, String methodName, String methodDesc, String mixinClassName) {
        return classNode.methods.stream().filter(mn -> {
            String[] methodUniqueNames = methodName.split("\\$", 3);
            return methodUniqueNames.length == 3 && methodUniqueNames[2].equals(mn.name) && !mn.desc.equals(methodDesc) && ASMUtils.isRedirectSurrogateMethod(mn, mixinClassName);
        }).findFirst();
    }

    public static int findLocalVariableIndex(MethodNode mn, String desc, int ordinal) {
        ArrayList localVariables = Lists.newArrayList((Iterable)mn.localVariables);
        localVariables.sort(Comparator.comparingInt(o -> o.index));
        for (LocalVariableNode lvn : localVariables) {
            if (!lvn.desc.equals(desc)) continue;
            if (ordinal == 0) {
                return lvn.index;
            }
            --ordinal;
        }
        return -1;
    }

    public static InsnList createRedirectSurrogateVarInsnList(MethodNode targetMethod, MethodNode surrogateMethod, String redirectMethodDesc) {
        Integer[] ordinals = (Integer[])surrogateMethod.visibleAnnotations.stream().filter(an -> an.desc.equals(Type.getDescriptor(RedirectSurrogate.class))).flatMap(an -> ((List)an.values.get(1)).stream()).toArray(Integer[]::new);
        Type[] surrogateTypes = Type.getArgumentTypes((String)surrogateMethod.desc);
        int redirectMethodDescTypesLength = Type.getArgumentTypes((String)redirectMethodDesc).length;
        InsnList il = new InsnList();
        IntStream.range(redirectMethodDescTypesLength, surrogateTypes.length).forEachOrdered(i -> il.add((AbstractInsnNode)new VarInsnNode(surrogateTypes[i].getOpcode(21), ASMUtils.findLocalVariableIndex(targetMethod, surrogateTypes[i].getDescriptor(), ordinals[i - redirectMethodDescTypesLength]))));
        return il;
    }

    public static boolean isMixinMethodNodeInTargetClass(ClassNode cn, String methodName, String methodDesc, String mixinClassName) {
        return cn.methods.stream().anyMatch(mn -> mn.name.equals(methodName) && mn.desc.equals(methodDesc) && ASMUtils.isMixinMethod(mn, mixinClassName));
    }

    public static boolean isMixinMethod(MethodNode mn, String mixinClassName) {
        return mn.visibleAnnotations != null && mn.visibleAnnotations.stream().anyMatch(an -> an.desc.equals(Type.getDescriptor(MixinMerged.class)) && an.values.contains(mixinClassName));
    }

    public static boolean isRedirectSurrogateMethod(MethodNode mn, String mixinClassName) {
        return ASMUtils.isMixinMethod(mn, mixinClassName) && mn.visibleAnnotations.stream().anyMatch(an -> an.desc.equals(Type.getDescriptor(RedirectSurrogate.class)));
    }

    public static FieldInsnNode findFirstFieldInsnNode(MethodNode mn, int opcode, String owner, String name, String desc) {
        for (AbstractInsnNode ain : mn.instructions.toArray()) {
            if (!(ain instanceof FieldInsnNode) || ain.getOpcode() != opcode) continue;
            FieldInsnNode fin = (FieldInsnNode)ain;
            if (!fin.owner.equals(owner) || !fin.name.equals(name) || !fin.desc.equals(desc)) continue;
            return fin;
        }
        return null;
    }
}

