/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.packedup.BackpackInventory;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PUConfig;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.PacketMaxLayers;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.SERVER})
public class BackpackStorageManager {
    private static File directory;
    private static final HashMap<Integer, BackpackInventory> inventories;
    private static int inventoryIndex;
    public static int maxLayers;

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save event) {
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        BackpackStorageManager.save();
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        maxLayers = PUConfig.allowBagInBag ? PUConfig.maxBagInBagLayer : 0;
        WorldServer world = (WorldServer)event.getWorld();
        directory = new File(world.func_72860_G().func_75765_b(), "packedup/backpacks");
        BackpackStorageManager.load();
    }

    public static BackpackInventory getInventory(int index) {
        File file;
        BackpackInventory inventory = inventories.get(index);
        if (inventory == null && (file = new File(directory, "inventory" + index + ".nbt")).exists()) {
            inventory = new BackpackInventory(false, index);
            inventory.load(file);
            inventories.put(index, inventory);
        }
        return inventory;
    }

    public static int createInventoryIndex(BackpackType type) {
        int index = inventoryIndex++;
        inventories.put(index, new BackpackInventory(false, index, type.getRows()));
        return index;
    }

    public static void save() {
        directory.mkdirs();
        for (int i : inventories.keySet()) {
            inventories.get(i).save(new File(directory, "inventory" + i + ".nbt"));
        }
    }

    public static void load() {
        int index;
        File[] files = directory.listFiles();
        inventories.clear();
        if (files == null) {
            files = new File[]{};
        }
        int highest = -1;
        for (File file : files) {
            String name = file.getName();
            if (!name.startsWith("inventory") || !name.endsWith(".nbt")) continue;
            try {
                index = Integer.parseInt(name.substring("inventory".length(), name.length() - ".nbt".length()));
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (index > highest) {
                highest = index;
            }
            BackpackInventory inventory = new BackpackInventory(false, index);
            inventory.load(file);
            inventory.bagsThisBagIsIn.clear();
            inventory.bagsThisBagIsDirectlyIn.clear();
            inventory.bagsInThisBag.clear();
            inventory.bagsDirectlyInThisBag.clear();
            inventory.layer = 0;
            inventories.put(index, inventory);
        }
        inventoryIndex = highest + 1;
        for (Map.Entry entry : inventories.entrySet()) {
            BackpackInventory inventory = (BackpackInventory)entry.getValue();
            for (ItemStack stack : inventory.getStacks()) {
                if (!(stack.func_77973_b() instanceof BackpackItem) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("packedup:invIndex")) continue;
                index = stack.func_77978_p().func_74762_e("packedup:invIndex");
                if (!inventories.containsKey(index)) {
                    stack.func_77978_p().func_82580_o("packedup:invIndex");
                    continue;
                }
                inventory.bagsDirectlyInThisBag.add(index);
                BackpackStorageManager.inventories.get((Object)Integer.valueOf((int)index)).bagsThisBagIsDirectlyIn.add((Integer)entry.getKey());
            }
        }
        for (Map.Entry entry : inventories.entrySet()) {
            BackpackInventory inventory = (BackpackInventory)entry.getValue();
            inventory.layer = BackpackStorageManager.getBagsThisBagIsIn((Integer)entry.getKey(), inventory.bagsThisBagIsIn);
            BackpackStorageManager.getBagsInThisBag((Integer)entry.getKey(), inventory.bagsInThisBag);
        }
        BackpackStorageManager.save();
        inventories.clear();
    }

    private static Integer getBagsThisBagIsIn(int index, Set<Integer> bags) {
        if (BackpackStorageManager.getInventory(index) == null) {
            return 0;
        }
        int highest = 0;
        for (int id : BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn) {
            if (bags.contains(id)) continue;
            bags.add(id);
            highest = Math.max(highest, BackpackStorageManager.getBagsThisBagIsIn(id, bags)) + 1;
        }
        return highest;
    }

    private static void getBagsInThisBag(int index, Set<Integer> bags) {
        if (BackpackStorageManager.getInventory(index) == null) {
            return;
        }
        for (int id : BackpackStorageManager.getInventory((int)index).bagsDirectlyInThisBag) {
            if (bags.contains(id)) continue;
            bags.add(id);
            BackpackStorageManager.getBagsInThisBag(id, bags);
        }
    }

    public static void onInsert(int index, int to) {
        BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn.add(to);
        BackpackStorageManager.getInventory((int)to).bagsDirectlyInThisBag.add(index);
        BackpackStorageManager.updateRelativeBags(index, to);
    }

    public static void onExtract(int index, int from) {
        BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn.remove(from);
        BackpackStorageManager.getInventory((int)from).bagsDirectlyInThisBag.remove(index);
        BackpackStorageManager.updateRelativeBags(index, from);
    }

    private static void updateRelativeBags(int child, int parent) {
        BackpackInventory inv;
        BackpackInventory childInventory = BackpackStorageManager.getInventory(child);
        BackpackInventory parentInventory = BackpackStorageManager.getInventory(parent);
        Set<Integer> bagsBefore = parentInventory.bagsThisBagIsIn;
        bagsBefore.add(parent);
        Set<Integer> bagsAfter = childInventory.bagsInThisBag;
        bagsAfter.add(child);
        for (int id : bagsBefore) {
            inv = BackpackStorageManager.getInventory(id);
            inv.bagsInThisBag.clear();
            BackpackStorageManager.getBagsInThisBag(id, inv.bagsInThisBag);
        }
        for (int id : bagsAfter) {
            inv = BackpackStorageManager.getInventory(id);
            inv.bagsThisBagIsIn.clear();
            inv.layer = BackpackStorageManager.getBagsThisBagIsIn(id, inv.bagsThisBagIsIn);
        }
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.player.func_130014_f_().field_72995_K) {
            PackedUp.channel.sendTo((IMessage)new PacketMaxLayers(maxLayers), (EntityPlayerMP)e.player);
        }
    }

    static {
        inventories = new HashMap();
        inventoryIndex = 0;
        maxLayers = 3;
    }
}

