/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.packedup.BackpackContainer;
import com.supermartijn642.packedup.BackpackInventory;
import com.supermartijn642.packedup.BackpackStorageManager;
import com.supermartijn642.packedup.ClientProxy;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBackpackContainer
implements IMessage,
IMessageHandler<PacketBackpackContainer, IMessage> {
    private int inventoryIndex;
    private Set<Integer> bagsInThisBag;
    private Set<Integer> bagsThisBagIsIn;
    private int layer;

    public PacketBackpackContainer(int inventoryIndex) {
        this.inventoryIndex = inventoryIndex;
    }

    public PacketBackpackContainer() {
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.bagsInThisBag = new HashSet<Integer>(size);
        for (i = 0; i < size; ++i) {
            this.bagsInThisBag.add(buf.readInt());
        }
        size = buf.readInt();
        this.bagsThisBagIsIn = new HashSet<Integer>(size);
        for (i = 0; i < size; ++i) {
            this.bagsThisBagIsIn.add(buf.readInt());
        }
        this.layer = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        BackpackInventory inventory = BackpackStorageManager.getInventory(this.inventoryIndex);
        buf.writeInt(inventory.bagsInThisBag.size());
        inventory.bagsInThisBag.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
        buf.writeInt(inventory.bagsThisBagIsIn.size());
        inventory.bagsThisBagIsIn.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
        buf.writeInt(inventory.layer);
    }

    public IMessage onMessage(PacketBackpackContainer message, MessageContext ctx) {
        EntityPlayer player = ClientProxy.getClientPlayer();
        ClientProxy.addScheduledTask(() -> {
            if (player.field_71070_bA instanceof BackpackContainer) {
                BackpackContainer container = (BackpackContainer)player.field_71070_bA;
                container.inventory.bagsInThisBag.addAll(message.bagsInThisBag);
                container.inventory.bagsThisBagIsIn.addAll(message.bagsThisBagIsIn);
                container.inventory.layer = message.layer;
            }
        });
        return null;
    }
}

