/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.google.common.collect.Lists;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackStorageManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BackpackInventory
implements IItemHandlerModifiable {
    private final boolean remote;
    private final ArrayList<ItemStack> stacks = new ArrayList();
    private final int inventoryIndex;
    public int rows;
    public Set<Integer> bagsInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsDirectlyInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsIn = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsDirectlyIn = new HashSet<Integer>();
    public int layer;

    public BackpackInventory(boolean remote, int inventoryIndex, int rows, Set<Integer> bagsInThisBag, Set<Integer> bagsThisBagIsIn, int layer) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        this.rows = rows;
        for (int a = 0; a < this.rows * 9; ++a) {
            this.stacks.add(ItemStack.field_190927_a);
        }
        this.bagsInThisBag.addAll(bagsInThisBag);
        this.bagsThisBagIsIn.addAll(bagsThisBagIsIn);
        this.layer = layer;
    }

    public BackpackInventory(boolean remote, int inventoryIndex, int rows) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        this.rows = rows;
        for (int a = 0; a < this.rows * 9; ++a) {
            this.stacks.add(ItemStack.field_190927_a);
        }
    }

    public BackpackInventory(boolean remote, int inventoryIndex) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
    }

    public int getSlots() {
        return this.rows * 9;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_77973_b() instanceof BackpackItem && !this.isBagAllowed(stack)) {
            return stack;
        }
        ItemStack current = this.stacks.get(slot);
        if (!stack.func_190926_b() && this.isItemValid(slot, stack) && BackpackInventory.canStack(current, stack)) {
            int amount = Math.min(stack.func_190916_E(), 64 - current.func_190916_E());
            if (!simulate) {
                int index;
                ItemStack newStack = stack.func_77946_l();
                newStack.func_190920_e(current.func_190916_E() + amount);
                this.stacks.set(slot, newStack);
                if (!this.remote && stack.func_77973_b() instanceof BackpackItem && stack.func_196082_o().func_74764_b("packedup:invIndex") && !this.bagsDirectlyInThisBag.contains(index = stack.func_196082_o().func_74762_e("packedup:invIndex"))) {
                    BackpackStorageManager.onInsert(index, this.inventoryIndex);
                }
            }
            ItemStack result = stack.func_77946_l();
            result.func_190918_g(amount);
            return result;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.stacks.get(slot);
        int count = Math.min(amount, stack.func_190916_E());
        ItemStack result = stack.func_77946_l();
        if (!simulate) {
            stack.func_190918_g(count);
            if (!this.remote && result.func_77973_b() instanceof BackpackItem && result.func_196082_o().func_74764_b("packedup:invIndex")) {
                int index = result.func_196082_o().func_74762_e("packedup:invIndex");
                boolean contains = false;
                for (ItemStack stack1 : this.stacks) {
                    if (!(stack1.func_77973_b() instanceof BackpackItem) || !stack1.func_196082_o().func_74764_b("packedup:invIndex") || stack1.func_196082_o().func_74762_e("packedup:invIndex") != index) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    BackpackStorageManager.onExtract(index, this.inventoryIndex);
                }
            }
        }
        result.func_190920_e(count);
        return result;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        CompoundNBT compound;
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock && stack.func_77942_o() && (compound = stack.func_77978_p().func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            NonNullList items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)items);
            for (ItemStack stack1 : items) {
                if (!(stack1.func_77973_b() instanceof BackpackItem)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() || stack2.func_190926_b() || stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void save(File file) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("rows", this.rows);
        compound.func_74768_a("stacks", this.stacks.size());
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            compound.func_218657_a("stack" + slot, (INBT)this.stacks.get(slot).func_77955_b(new CompoundNBT()));
        }
        compound.func_197646_b("bagsInThisBag", (List)Lists.newArrayList(this.bagsInThisBag));
        compound.func_197646_b("bagsThisBagIsIn", (List)Lists.newArrayList(this.bagsThisBagIsIn));
        compound.func_74768_a("layer", this.layer);
        try {
            CompressedStreamTools.func_74795_b((CompoundNBT)compound, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        CompoundNBT compound;
        try {
            compound = CompressedStreamTools.func_74797_a((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.rows = compound.func_74764_b("rows") ? compound.func_74762_e("rows") : compound.func_74762_e("slots") / 9;
        this.stacks.clear();
        int size = compound.func_74764_b("stacks") ? compound.func_74762_e("stacks") : this.rows * 9;
        for (int slot = 0; slot < size; ++slot) {
            this.stacks.add(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("stack" + slot)));
        }
        this.bagsInThisBag.clear();
        Arrays.stream(compound.func_74759_k("bagsInThisBag")).forEach(this.bagsInThisBag::add);
        this.bagsThisBagIsIn.clear();
        Arrays.stream(compound.func_74759_k("bagsThisBagIsIn")).forEach(this.bagsThisBagIsIn::add);
        this.layer = compound.func_74762_e("layer");
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int index;
        ItemStack oldStack = this.stacks.get(slot);
        this.stacks.set(slot, ItemStack.field_190927_a);
        if (!this.remote && oldStack.func_77973_b() instanceof BackpackItem && oldStack.func_196082_o().func_74764_b("packedup:invIndex")) {
            index = oldStack.func_196082_o().func_74762_e("packedup:invIndex");
            boolean contains = false;
            for (ItemStack stack1 : this.stacks) {
                if (!(stack1.func_77973_b() instanceof BackpackItem) || !stack1.func_196082_o().func_74764_b("packedup:invIndex") || stack1.func_196082_o().func_74762_e("packedup:invIndex") != index) continue;
                contains = true;
                break;
            }
            if (!contains) {
                BackpackStorageManager.onExtract(index, this.inventoryIndex);
            }
        }
        this.stacks.set(slot, stack);
        if (!this.remote && stack.func_77973_b() instanceof BackpackItem && stack.func_196082_o().func_74764_b("packedup:invIndex") && !this.bagsDirectlyInThisBag.contains(index = stack.func_196082_o().func_74762_e("packedup:invIndex"))) {
            BackpackStorageManager.onInsert(index, this.inventoryIndex);
        }
    }

    public void adjustSize(int rows) {
        if (this.rows == rows) {
            return;
        }
        this.rows = rows;
        while (this.stacks.size() < this.rows * 9) {
            this.stacks.add(ItemStack.field_190927_a);
        }
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    private boolean isBagAllowed(ItemStack bag) {
        if (BackpackStorageManager.maxLayers != -1 && this.layer >= BackpackStorageManager.maxLayers) {
            return false;
        }
        if (!bag.func_196082_o().func_74764_b("packedup:invIndex")) {
            return true;
        }
        int index = bag.func_196082_o().func_74762_e("packedup:invIndex");
        return index != this.inventoryIndex && !this.bagsThisBagIsIn.contains(index);
    }
}

