/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.packedup.BackpackType;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PUConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final PUConfig INSTANCE;
    public ForgeConfigSpec.BooleanValue allowBagInBag;
    public ForgeConfigSpec.IntValue maxBagInBagLayer;
    public ForgeConfigSpec.BooleanValue basicEnable;
    public ForgeConfigSpec.IntValue basicRows;
    public ForgeConfigSpec.BooleanValue ironEnable;
    public ForgeConfigSpec.IntValue ironRows;
    public ForgeConfigSpec.BooleanValue copperEnable;
    public ForgeConfigSpec.IntValue copperRows;
    public ForgeConfigSpec.BooleanValue silverEnable;
    public ForgeConfigSpec.IntValue silverRows;
    public ForgeConfigSpec.BooleanValue goldEnable;
    public ForgeConfigSpec.IntValue goldRows;
    public ForgeConfigSpec.BooleanValue diamondEnable;
    public ForgeConfigSpec.IntValue diamondRows;
    public ForgeConfigSpec.BooleanValue obsidianEnable;
    public ForgeConfigSpec.IntValue obsidianRows;

    private PUConfig(ForgeConfigSpec.Builder builder) {
        this.allowBagInBag = builder.worldRestart().comment("Can backpacks be put inside other backpacks?").define("allowBagInBag", true);
        this.maxBagInBagLayer = builder.worldRestart().comment("How many layers deep can you place backpacks inside backpacks? -1 for infinite, 0 is the same as setting 'allowBagInBag' to false.").defineInRange("maxBagInBagLayer", -1, -1, 5);
        this.basicRows = builder.worldRestart().comment("How many rows does the basic backpack have?").defineInRange("rowsBasic", BackpackType.BASIC.getDefaultRows(), 1, 13);
        this.ironRows = builder.worldRestart().comment("How many rows does the iron backpack have?").defineInRange("rowsIron", BackpackType.IRON.getDefaultRows(), 1, 13);
        this.copperRows = builder.worldRestart().comment("How many rows does the copper backpack have?").defineInRange("rowsCopper", BackpackType.COPPER.getDefaultRows(), 1, 13);
        this.silverRows = builder.worldRestart().comment("How many rows does the silver backpack have?").defineInRange("rowsSilver", BackpackType.SILVER.getDefaultRows(), 1, 13);
        this.goldRows = builder.worldRestart().comment("How many rows does the gold backpack have?").defineInRange("rowsGold", BackpackType.GOLD.getDefaultRows(), 1, 13);
        this.diamondRows = builder.worldRestart().comment("How many rows does the diamond backpack have?").defineInRange("rowsDiamond", BackpackType.DIAMOND.getDefaultRows(), 1, 13);
        this.obsidianRows = builder.worldRestart().comment("How many rows does the obsidian backpack have?").defineInRange("rowsObsidian", BackpackType.OBSIDIAN.getDefaultRows(), 1, 13);
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(PUConfig::new);
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (PUConfig)pair.getLeft();
    }
}

