/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonBook
extends Button {
    final GuiBook parent;
    final int u;
    final int v;
    final Supplier<Boolean> displayCondition;
    final List<String> tooltip;

    public GuiButtonBook(GuiBook parent, int x, int y, int u, int v, int w, int h, Button.IPressable onPress, String ... tooltip) {
        this(parent, x, y, u, v, w, h, () -> true, onPress, tooltip);
    }

    public GuiButtonBook(GuiBook parent, int x, int y, int u, int v, int w, int h, Supplier<Boolean> displayCondition, Button.IPressable onPress, String ... tooltip) {
        super(x, y, w, h, tooltip[0], onPress);
        this.parent = parent;
        this.u = u;
        this.v = v;
        this.displayCondition = displayCondition;
        this.tooltip = Arrays.asList(tooltip);
    }

    public final void render(int mouseX, int mouseY, float partialTicks) {
        this.active = this.visible = this.displayCondition.get().booleanValue();
        super.render(mouseX, mouseY, partialTicks);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(this.parent.book, this.x, this.y, this.u + (this.isHovered() ? this.width : 0), this.v, this.width, this.height);
        if (this.isHovered) {
            this.parent.setTooltip(this.getTooltip());
        }
    }

    public void playDownSound(SoundHandler soundHandlerIn) {
        GuiBook.playBookFlipSound(this.parent.book);
    }

    public List<String> getTooltip() {
        return this.tooltip;
    }
}

