/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonEntry
extends Button {
    private static final int ANIM_TIME = 5;
    private final GuiBook parent;
    private final BookEntry entry;
    private float timeHovered;

    public GuiButtonEntry(GuiBook parent, int x, int y, BookEntry entry, Button.IPressable onPress) {
        super(x, y, 116, 10, entry.getName(), onPress);
        this.parent = parent;
        this.entry = entry;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.active) {
            this.timeHovered = this.isHovered() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.isHovered() ? partialTicks : -partialTicks)));
            float widthFract = time / 5.0f;
            boolean locked = this.entry.isLocked();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            AbstractGui.fill((int)(this.x * 2), (int)(this.y * 2), (int)((this.x + (int)((float)this.width * widthFract)) * 2), (int)((this.y + this.height) * 2), (int)0x22000000);
            GlStateManager.enableBlend();
            if (locked) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(this.parent.book, this.x * 2 + 2, this.y * 2 + 2);
            } else {
                this.entry.getIcon().render(this.x * 2 + 2, this.y * 2 + 2);
            }
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            String name = (this.entry.isPriority() ? TextFormatting.ITALIC : "") + this.entry.getName();
            if (locked) {
                name = I18n.func_135052_a((String)"patchouli.gui.lexicon.locked", (Object[])new Object[0]);
            }
            int color = this.getColor();
            this.entry.getBook().getFont().func_211126_b(name, (float)(this.x + 12), (float)this.y, color);
            if (!this.entry.isLocked()) {
                GuiBook.drawMarking(this.parent.book, this.x + this.width - 5, this.y + 1, this.entry.hashCode(), this.entry.getReadState());
            }
        }
    }

    private int getColor() {
        if (this.entry.isSecret()) {
            return 0xAA000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        if (this.entry.isLocked()) {
            return 0x77000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        return this.entry.getEntryColor();
    }

    public void playDownSound(SoundHandler soundHandlerIn) {
        if (this.entry != null && !this.entry.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }
}

