/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.book.Book;

public class PageQuest
extends PageWithText {
    String trigger;
    String title;
    transient BookTextRenderer infoText;
    transient boolean isManual;
    transient int footerY;
    transient Button button;

    @Override
    public int getTextHeight() {
        return 22;
    }

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.isManual = this.trigger == null || this.trigger.isEmpty();
    }

    public boolean isCompleted(Book book) {
        return this.isManual ? PersistentData.data.getBookData((Book)book).completedManualQuests.contains(this.entry.getId().toString()) : this.trigger != null && !this.trigger.isEmpty() && ClientAdvancements.hasDone(this.trigger);
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.isManual) {
            this.button = new Button(8, 121, 100, 20, "", this::questButtonClicked);
            this.addButton(this.button);
            this.updateButtonText();
        }
    }

    private void updateButtonText() {
        boolean completed = this.isCompleted(this.parent.book);
        String s = I18n.func_135052_a((String)(completed ? "patchouli.gui.lexicon.mark_incomplete" : "patchouli.gui.lexicon.mark_complete"), (Object[])new Object[0]);
        this.button.setMessage(s);
    }

    protected void questButtonClicked(Button button) {
        String res = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.parent.book);
        if (data.completedManualQuests.contains(res)) {
            data.completedManualQuests.remove(res);
        } else {
            data.completedManualQuests.add(res);
        }
        PersistentData.save();
        this.updateButtonText();
        this.entry.markReadStateDirty();
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        super.render(mouseX, mouseY, pticks);
        this.parent.drawCenteredStringNoShadow(this.title == null || this.title.isEmpty() ? I18n.func_135052_a((String)"patchouli.gui.lexicon.objective", (Object[])new Object[0]) : this.i18n(this.title), 58, 0, this.book.headerColor);
        GuiBook.drawSeparator(this.book, 0, 12);
        if (!this.isManual) {
            GuiBook.drawSeparator(this.book, 0, 131);
            boolean completed = this.isCompleted(this.parent.book);
            String s = I18n.func_135052_a((String)(completed ? "patchouli.gui.lexicon.complete" : "patchouli.gui.lexicon.incomplete"), (Object[])new Object[0]);
            int color = completed ? 35610 : this.book.headerColor;
            this.parent.drawCenteredStringNoShadow(s, 58, 139, color);
        }
    }
}

