/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page.abstr;

import com.google.gson.annotations.SerializedName;
import net.minecraft.item.ItemStack;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;

public abstract class PageDoubleRecipe<T>
extends PageWithText {
    @SerializedName(value="recipe")
    String recipeRaw;
    @SerializedName(value="recipe2")
    String recipe2Raw;
    String title;
    protected transient T recipe1;
    protected transient T recipe2;
    protected transient String title1;
    protected transient String title2;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.recipe1 = this.loadRecipe(entry, this.recipeRaw);
        this.recipe2 = this.loadRecipe(entry, this.recipe2Raw);
        if (this.recipe1 == null && this.recipe2 != null) {
            this.recipe1 = this.recipe2;
            this.recipe2 = null;
        }
        boolean customTitle = this.title != null && !this.title.isEmpty();
        this.title1 = !customTitle ? this.getRecipeOutput(this.recipe1).func_200301_q().func_150254_d() : this.title;
        this.title2 = "-";
        if (this.recipe2 != null) {
            String string = this.title2 = !customTitle ? this.getRecipeOutput(this.recipe2).func_200301_q().func_150254_d() : "";
            if (this.title1.equals(this.title2)) {
                this.title2 = "";
            }
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        if (this.recipe1 != null) {
            int recipeX = this.getX();
            int recipeY = this.getY();
            this.drawRecipe(this.recipe1, recipeX, recipeY, mouseX, mouseY, false);
            if (this.recipe2 != null) {
                this.drawRecipe(this.recipe2, recipeX, recipeY + this.getRecipeHeight() - (this.title2.isEmpty() ? 10 : 0), mouseX, mouseY, true);
            }
        }
        super.render(mouseX, mouseY, pticks);
    }

    @Override
    public int getTextHeight() {
        return this.getY() + this.getRecipeHeight() * (this.recipe2 == null ? 1 : 2) - (this.title2.isEmpty() ? 23 : 13);
    }

    @Override
    public boolean shouldRenderText() {
        return this.getTextHeight() + 10 < 156;
    }

    protected abstract void drawRecipe(T var1, int var2, int var3, int var4, int var5, boolean var6);

    protected abstract T loadRecipe(BookEntry var1, String var2);

    protected abstract ItemStack getRecipeOutput(T var1);

    protected abstract int getRecipeHeight();

    protected int getX() {
        return 9;
    }

    protected int getY() {
        return 4;
    }

    protected String getTitle(boolean second) {
        return this.i18n(second ? this.title2 : this.title1);
    }
}

