/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookFolderLoader;

public class BookRegistry {
    public static final BookRegistry INSTANCE = new BookRegistry();
    public static final String BOOKS_LOCATION = "patchouli_books";
    public final Map<ResourceLocation, Book> books = new HashMap<ResourceLocation, Book>();
    public Gson gson = new GsonBuilder().create();
    private boolean loaded = false;

    private BookRegistry() {
    }

    public void init() {
        List mods = ModList.get().getMods();
        HashMap<Pair, String> foundBooks = new HashMap<Pair, String>();
        mods.forEach(mod -> {
            String id = mod.getModId();
            BookRegistry.findFiles(mod, String.format("data/%s/%s", id, BOOKS_LOCATION), path -> Files.exists(path, new LinkOption[0]), (path, file) -> {
                if (file.toString().endsWith("book.json")) {
                    String fileStr = file.toString().replaceAll("\\\\", "/");
                    String relPath = fileStr.substring(fileStr.indexOf(BOOKS_LOCATION) + BOOKS_LOCATION.length() + 1);
                    String bookName = relPath.substring(0, relPath.indexOf("/"));
                    if (bookName.contains("/")) {
                        Patchouli.LOGGER.warn("Ignored book.json @ {}", file);
                        return true;
                    }
                    String assetPath = fileStr.substring(fileStr.indexOf("/data"));
                    ResourceLocation bookId = new ResourceLocation(id, bookName);
                    foundBooks.put(Pair.of((Object)mod, (Object)bookId), assetPath);
                }
                return true;
            }, false, true);
        });
        foundBooks.forEach((pair, file) -> {
            ModInfo mod = (ModInfo)pair.getLeft();
            Optional container = ModList.get().getModContainerById(mod.getModId());
            container.ifPresent(c -> {
                ResourceLocation res = (ResourceLocation)pair.getRight();
                Class<?> ownerClass = c.getMod().getClass();
                try (InputStream stream = ownerClass.getResourceAsStream((String)file);){
                    this.loadBook((IModInfo)mod, ownerClass, res, stream, false);
                }
                catch (Exception e) {
                    Patchouli.LOGGER.error("Failed to load book {} defined by mod {}, skipping", (Object)res, (Object)c.getModInfo().getModId(), (Object)e);
                }
            });
        });
        BookFolderLoader.findBooks();
    }

    public void loadBook(IModInfo mod, Class<?> ownerClass, ResourceLocation res, InputStream stream, boolean external) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        Book book = (Book)this.gson.fromJson((Reader)reader, Book.class);
        book.build(mod, ownerClass, res, external);
        this.books.put(res, book);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void reloadContents() {
        this.books.values().forEach(Book::reloadContents);
        this.books.values().forEach(Book::reloadExtensionContents);
        ClientBookRegistry.INSTANCE.reloadLocks(false);
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    /*
     * Exception decompiling
     */
    public static boolean findFiles(ModInfo mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor, boolean defaultUnfoundRoot, boolean visitAllFiles) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

