/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import vazkii.patchouli.common.network.NetworkHandler;
import vazkii.patchouli.common.network.message.MessageSyncAdvancements;

@Mod.EventBusSubscriber
public final class AdvancementSyncHandler {
    public static final Set<String> trackedNamespaces = new HashSet<String>();
    private static Set<ResourceLocation> syncedAdvancements = Collections.emptySet();

    @SubscribeEvent
    public static void serverStartedEvent(FMLServerStartedEvent evt) {
        AdvancementSyncHandler.recomputeSyncedAdvancements(evt.getServer());
    }

    public static void recomputeSyncedAdvancements(MinecraftServer server) {
        AdvancementManager manager = server.func_191949_aK();
        syncedAdvancements = manager.func_195438_b().stream().filter(a -> trackedNamespaces.contains(a.func_192067_g().func_110624_b())).map(Advancement::func_192067_g).collect(Collectors.toSet());
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            if (syncedAdvancements.contains(event.getAdvancement().func_192067_g())) {
                AdvancementSyncHandler.syncPlayer(player, true);
            }
        }
    }

    public static void loginSync(ServerPlayerEntity player) {
        AdvancementSyncHandler.syncPlayer(player, false);
    }

    public static void syncPlayer(ServerPlayerEntity player, boolean showToast) {
        PlayerAdvancements advancements = player.func_192039_O();
        if (advancements == null) {
            return;
        }
        AdvancementManager manager = player.func_184102_h().func_191949_aK();
        LinkedList<String> completed = new LinkedList<String>();
        for (ResourceLocation res : syncedAdvancements) {
            AdvancementProgress p;
            Advancement adv = manager.func_192778_a(res);
            if (adv == null || !(p = advancements.func_192747_a(adv)).func_192105_a()) continue;
            completed.add(res.toString());
        }
        String[] completedArr = completed.toArray(new String[0]);
        NetworkHandler.sendToPlayer(new MessageSyncAdvancements(completedArr, showToast), player);
    }
}

