/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_327;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.book.Book;

public class BookTextRenderer {
    private final Book book;
    private final GuiBook gui;
    private final String text;
    private final int x;
    private final int y;
    private final int width;
    private final int lineHeight;
    private final int baseColor;
    private List<Word> words;

    public BookTextRenderer(GuiBook gui, String text, int x, int y) {
        this(gui, text, x, y, 116, 9, gui.book.textColor);
    }

    public BookTextRenderer(GuiBook gui, String text, int x, int y, int width, int lineHeight, int baseColor) {
        this.book = gui.book;
        this.gui = gui;
        this.text = this.book.i18n ? class_1074.method_4662((String)text, (Object[])new Object[0]) : text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.lineHeight = lineHeight;
        this.baseColor = baseColor;
        this.build();
    }

    private void build() {
        BookTextParser parser = new BookTextParser(this.gui, this.book, this.x, this.y, this.width, this.lineHeight, this.baseColor);
        this.words = parser.parse(this.text);
    }

    public void render(int mouseX, int mouseY) {
        class_327 font = this.book.getFont();
        this.words.forEach(word -> word.render(font, mouseX, mouseY));
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        for (Word word : this.words) {
            if (!word.click(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }
}

