/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4357;
import net.minecraft.class_437;
import vazkii.patchouli.api.BookDrawScreenCallback;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBack;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBook
extends class_437 {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public final Book book;
    private static long lastSound;
    public int bookLeft;
    public int bookTop;
    private float scaleFactor;
    private List<class_2561> tooltip;
    private class_1799 tooltipStack;
    private Pair<BookEntry, Integer> targetPage;
    protected int spread = 0;
    protected int maxSpreads = 0;
    public int ticksInBook;
    public int maxScale;
    boolean needsBookmarkUpdate = false;

    public GuiBook(Book book, class_2561 title) {
        super(title);
        this.book = book;
    }

    public void init() {
        class_1041 res = this.minecraft.method_22683();
        double oldGuiScale = res.method_4476(this.minecraft.field_1690.field_1868, this.minecraft.method_1573());
        this.maxScale = this.getMaxAllowedScale();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        double newGuiScale = res.method_4476(persistentScale, this.minecraft.method_1573());
        if (persistentScale > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.method_4495();
            res.method_15997(newGuiScale);
            this.width = res.method_4486();
            this.height = res.method_4502();
            res.method_15997(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.bookLeft = this.width / 2 - 136;
        this.bookTop = this.height / 2 - 90;
        this.book.contents.currentGui = this;
        this.addButton(new GuiButtonBookBack(this, this.width / 2 - 9, this.bookTop + 180 - 5));
        this.addButton(new GuiButtonBookArrow(this, this.bookLeft - 4, this.bookTop + 180 - 6, true));
        this.addButton(new GuiButtonBookArrow(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false));
        this.addBookmarkButtons();
    }

    public class_310 getMinecraft() {
        return this.minecraft;
    }

    public final void render(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        if (this.scaleFactor != 1.0f) {
            RenderSystem.scalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    final void drawScreenAfterScale(int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.renderBackground();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.bookLeft, (float)this.bookTop, (float)0.0f);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(mouseX, mouseY, partialTicks);
        this.drawForegroundElements(mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
        ((BookDrawScreenCallback)BookDrawScreenCallback.EVENT.invoker()).trigger(this.book.id, this, mouseX, mouseY, partialTicks);
        this.drawTooltip(mouseX, mouseY);
    }

    public void addBookmarkButtons() {
        this.removeButtonsIf(b -> b instanceof GuiButtonBookBookmark);
        int y = 0;
        List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
        for (PersistentData.DataHolder.BookData.Bookmark bookmark : bookmarks) {
            this.addButton(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, bookmark));
            y += 12;
        }
        y += y == 0 ? 0 : 2;
        if (this.shouldAddAddBookmarkButton() && bookmarks.size() <= 10) {
            this.addButton(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, null));
        }
        if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
            this.addButton(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 20, MultiblockVisualizationHandler.bookmark, true));
        }
    }

    public void removeButtonsIf(Predicate<class_364> pred) {
        this.buttons.removeIf(pred);
        this.children.removeIf(pred);
    }

    public void removeButtonsIn(Collection<?> coll) {
        this.removeButtonsIf(coll::contains);
    }

    public <T extends class_339> T addButton(T p_addButton_1_) {
        return (T)super.addButton(p_addButton_1_);
    }

    protected boolean shouldAddAddBookmarkButton() {
        return false;
    }

    public void bookmarkThis() {
    }

    public void onFirstOpened() {
    }

    public void tick() {
        if (!GuiBook.hasShiftDown()) {
            ++this.ticksInBook;
        }
        if (this.needsBookmarkUpdate) {
            this.needsBookmarkUpdate = false;
            this.addBookmarkButtons();
        }
    }

    final void drawBackgroundElements(int mouseX, int mouseY, float partialTicks) {
        GuiBook.drawFromTexture(this.book, 0, 0, 0, 0, 272, 180);
    }

    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
    }

    final void drawTooltip(int mouseX, int mouseY) {
        if (this.tooltipStack != null) {
            List tooltip = this.getTooltipFromItem(this.tooltipStack);
            Pair<BookEntry, Integer> provider = this.book.contents.getEntryForStack(this.tooltipStack);
            if (!(provider == null || this instanceof GuiBookEntry && ((GuiBookEntry)this).entry == provider.getFirst())) {
                tooltip.add(class_4357.field_19618 + "(" + class_1074.method_4662((String)"patchouli.gui.lexicon.shift_for_recipe", (Object[])new Object[0]) + ')');
                this.targetPage = provider;
            }
            this.renderTooltip(tooltip, mouseX, mouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            ArrayList wrappedTooltip = new ArrayList();
            for (class_2561 s : this.tooltip) {
                Collections.addAll(wrappedTooltip, s.method_10863().split("\n"));
            }
            this.renderTooltip(wrappedTooltip, mouseX, mouseY);
        }
    }

    final void resetTooltip() {
        this.tooltipStack = null;
        this.tooltip = null;
        this.targetPage = null;
    }

    public static void drawFromTexture(Book book, int x, int y, int u, int v, int w, int h) {
        class_310.method_1551().method_1531().method_22813(book.bookTexture);
        GuiBook.blit((int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public boolean isPauseScreen() {
        return this.book.pauseGame;
    }

    public void handleButtonBack(class_4185 button) {
        this.back(false);
    }

    public void handleButtonArrow(class_4185 button) {
        this.changePage(((GuiButtonBookArrow)button).left, false);
    }

    public void handleButtonBookmark(class_4185 button) {
        GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark)button;
        PersistentData.DataHolder.BookData.Bookmark bookmark = bookmarkButton.bookmark;
        if (bookmark == null || bookmark.getEntry(this.book) == null) {
            this.bookmarkThis();
        } else if (GuiBook.hasShiftDown() && !bookmarkButton.multiblock) {
            List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
            bookmarks.remove(bookmark);
            PersistentData.save();
            this.needsBookmarkUpdate = true;
        } else {
            this.displayLexiconGui(new GuiBookEntry(this.book, bookmark.getEntry(this.book), bookmark.page), true);
        }
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.mouseClickedScaled(mouseX / (double)this.scaleFactor, mouseY / (double)this.scaleFactor, mouseButton);
    }

    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                if (this.targetPage == null || !GuiBook.hasShiftDown()) break;
                this.displayLexiconGui(new GuiBookEntry(this.book, (BookEntry)this.targetPage.getFirst(), (Integer)this.targetPage.getSecond()), true);
                GuiBook.playBookFlipSound(this.book);
                return true;
            }
            case 1: {
                this.back(true);
                return true;
            }
            case 3: {
                this.changePage(true, true);
                return true;
            }
            case 4: {
                this.changePage(false, true);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259) {
            this.back(true);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.changePage(false, true);
        } else if (scroll > 0.0) {
            this.changePage(true, true);
        }
        return true;
    }

    void back(boolean sfx) {
        if (!this.book.contents.guiStack.isEmpty()) {
            if (GuiBook.hasShiftDown()) {
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.book.contents.guiStack.clear();
            } else {
                this.displayLexiconGui(this.book.contents.guiStack.pop(), false);
            }
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void changePage(boolean left, boolean sfx) {
        if (this.canSeePageButton(left)) {
            this.spread = left ? --this.spread : ++this.spread;
            this.onPageChanged();
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void onPageChanged() {
    }

    public boolean canBeOpened() {
        return true;
    }

    public boolean canSeePageButton(boolean left) {
        return left ? this.spread > 0 : this.spread + 1 < this.maxSpreads;
    }

    public boolean canSeeBackButton() {
        return !this.book.contents.guiStack.isEmpty();
    }

    public void setTooltip(class_2561 ... strings) {
        this.setTooltip(Arrays.asList(strings));
    }

    public void setTooltip(List<class_2561> strings) {
        this.tooltip = strings;
    }

    public void setTooltipStack(class_1799 stack) {
        this.setTooltip(Collections.emptyList());
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx - (double)this.bookLeft;
        double my = absMy - (double)this.bookTop;
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public void drawProgressBar(Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
        if (!book.showProgress || !book.advancementsEnabled()) {
            return;
        }
        int barLeft = 19;
        int barTop = 144;
        int barWidth = 106;
        int barHeight = 12;
        int totalEntries = 0;
        int unlockedEntries = 0;
        int unlockedSecretEntries = 0;
        for (BookEntry entry : book.contents.entries.values()) {
            if (!filter.test(entry)) continue;
            if (entry.isSecret()) {
                if (entry.isLocked()) continue;
                ++unlockedSecretEntries;
                continue;
            }
            BookCategory category = entry.getCategory();
            if (category.isSecret() && !category.isLocked()) continue;
            ++totalEntries;
            if (entry.isLocked()) continue;
            ++unlockedEntries;
        }
        float unlockFract = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        int progressWidth = (int)(((float)barWidth - 1.0f) * unlockFract);
        GuiBook.fill((int)barLeft, (int)barTop, (int)(barLeft + barWidth), (int)(barTop + barHeight), (int)book.headerColor);
        this.drawGradient(barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
        this.drawGradient(barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);
        this.font.method_1729(class_1074.method_4662((String)"patchouli.gui.lexicon.progress_meter", (Object[])new Object[0]), (float)barLeft, (float)(barTop - 9), book.headerColor);
        if (this.isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
            class_2588 progressStr = new class_2588("patchouli.gui.lexicon.progress_tooltip", new Object[]{unlockedEntries, totalEntries});
            tooltip.add((class_2561)progressStr);
            if (unlockedSecretEntries > 0) {
                if (unlockedSecretEntries == 1) {
                    tooltip.add(new class_2588("patchouli.gui.lexicon.progress_tooltip.secret1", new Object[0]).method_10854(class_124.field_1080));
                } else {
                    tooltip.add(new class_2588("patchouli.gui.lexicon.progress_tooltip.secret", new Object[]{unlockedSecretEntries}).method_10854(class_124.field_1080));
                }
            }
            if (unlockedEntries != totalEntries) {
                tooltip.add(new class_2588("patchouli.gui.lexicon.progress_tooltip.info", new Object[0]).method_10854(class_124.field_1080));
            }
            this.setTooltip(tooltip);
        }
    }

    private void drawGradient(int x, int y, int w, int h, int color) {
        int darkerColor = new Color(color).darker().getRGB();
        this.fillGradient(x, y, w, h, color, darkerColor);
    }

    public void drawCenteredStringNoShadow(String s, int x, int y, int color) {
        this.font.method_1729(s, (float)x - (float)this.font.method_1727(s) / 2.0f, (float)y, color);
    }

    private int getMaxAllowedScale() {
        return this.minecraft.method_22683().method_4476(0, this.minecraft.method_1573());
    }

    public int getSpread() {
        return this.spread;
    }

    public static void drawSeparator(Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x + 58 - w / 2;
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GuiBook.drawFromTexture(book, rx, y, 140, 180, w, h);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(Book book, int x, int y) {
        GuiBook.drawFromTexture(book, x, y, 250, 180, 16, 16);
    }

    public static void drawMarking(Book book, int x, int y, int rand, EntryDisplayState state) {
        if (!state.hasIcon) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        float alpha = state.hasAnimation ? (float)Math.sin(ClientTicker.total * 0.2f) * 0.3f + 0.7f : 1.0f;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiBook.drawFromTexture(book, x, y, state.u, 197, 8, 8);
        RenderSystem.enableAlphaTest();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawPageFiller(Book book) {
        GuiBook.drawPageFiller(book, 141, 18);
    }

    public static void drawPageFiller(Book book, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310.method_1551().method_1531().method_22813(book.fillerTexture);
        GuiBook.blit((int)(x + 58 - 64), (int)(y + 78 - 74), (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
    }

    public static void playBookFlipSound(Book book) {
        if (ClientTicker.ticksInGame - lastSound > 6L) {
            class_3414 sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.book_flip);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)sfx, (float)((float)(0.7 + Math.random() * 0.3))));
            lastSound = ClientTicker.ticksInGame;
        }
    }

    public static void openWebLink(String address) {
        class_156.method_668().method_670(address);
    }

    public void displayLexiconGui(GuiBook gui, boolean push) {
        this.book.contents.openLexiconGui(gui, push);
    }
}

