/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_824;
import net.minecraft.class_827;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEye;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.client.mixin.MixinBlockEntity;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

public class PageMultiblock
extends PageWithText {
    private static final Random RAND = new Random();
    String name = "";
    @SerializedName(value="multiblock_id")
    class_2960 multiblockId;
    @SerializedName(value="multiblock")
    SerializedMultiblock serializedMultiblock;
    @SerializedName(value="enable_visualize")
    boolean showVisualizeButton = true;
    private transient AbstractMultiblock multiblockObj;
    private transient class_4185 visualizeButton;
    private final transient Set<class_2586> erroredTiles = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void build(BookEntry entry, int pageNum) {
        IMultiblock mb;
        if (this.multiblockId != null && (mb = MultiblockRegistry.MULTIBLOCKS.get(this.multiblockId)) instanceof AbstractMultiblock) {
            this.multiblockObj = (AbstractMultiblock)mb;
        }
        if (this.multiblockObj == null && this.serializedMultiblock != null) {
            this.multiblockObj = this.serializedMultiblock.toMultiblock();
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.showVisualizeButton) {
            this.visualizeButton = new GuiButtonBookEye(parent, 12, 97, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(this.book, x, y, 405, 149, 106, 106);
        this.parent.drawCenteredStringNoShadow(this.name, 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock();
        }
        super.render(mouseX, mouseY, pticks);
    }

    public void handleButtonVisualize(class_4185 button) {
        String entryKey = this.parent.getEntry().getId().toString();
        PersistentData.DataHolder.BookData.Bookmark bookmark = new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.pageNum / 2);
        MultiblockVisualizationHandler.setMultiblock((IMultiblock)this.multiblockObj, (class_2561)new class_2585(this.name), bookmark, true);
        this.parent.addBookmarkButtons();
        if (!PersistentData.data.clickedVisualize) {
            PersistentData.data.clickedVisualize = true;
            PersistentData.save();
        }
    }

    private void renderMultiblock() {
        this.multiblockObj.setWorld((class_1937)this.mc.field_1687);
        class_2382 size = this.multiblockObj.getSize();
        int sizeX = size.method_10263();
        int sizeY = size.method_10264();
        int sizeZ = size.method_10260();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)xPos, (float)yPos, (float)100.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        RenderSystem.translatef((float)(-((float)sizeX) / 2.0f), (float)(-((float)sizeY) / 2.0f), (float)0.0f);
        class_1162 eye = new class_1162(0.0f, 0.0f, -100.0f, 1.0f);
        class_1159 rotMat = new class_1159();
        rotMat.method_22668();
        RenderSystem.rotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        rotMat.method_22670(class_1160.field_20703.method_23214(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!class_437.hasShiftDown()) {
            time += ClientTicker.partialTicks;
        }
        RenderSystem.translatef((float)(-offX), (float)0.0f, (float)(-offZ));
        RenderSystem.rotatef((float)time, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.method_22670(class_1160.field_20705.method_23214(-time));
        RenderSystem.rotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.method_22670(class_1160.field_20705.method_23214(-45.0f));
        RenderSystem.translatef((float)offX, (float)0.0f, (float)offZ);
        eye.method_22674(rotMat);
        eye.method_23219();
        this.renderElements(this.multiblockObj, class_2338.method_10097((class_2338)class_2338.field_10980, (class_2338)new class_2338(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);
        RenderSystem.popMatrix();
    }

    private void renderElements(AbstractMultiblock mb, Iterable<? extends class_2338> blocks, class_1162 eye) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
        class_4597.class_4598 buffers = class_310.method_1551().method_22940().method_23000();
        this.doWorldRenderPass(mb, blocks, buffers, eye);
        this.doTileEntityRenderPass(mb, blocks, (class_4597)buffers, eye);
        buffers.method_22993();
        RenderSystem.popMatrix();
    }

    private void doWorldRenderPass(AbstractMultiblock mb, Iterable<? extends class_2338> blocks, @Nonnull class_4597.class_4598 buffers, class_1162 eye) {
        class_4587 ms = new class_4587();
        for (class_2338 class_23382 : blocks) {
            class_2680 bs = mb.method_8320(class_23382);
            class_4588 buffer = buffers.getBuffer(class_4696.method_23679((class_2680)bs));
            ms.method_22903();
            ms.method_22904((double)class_23382.method_10263(), (double)class_23382.method_10264(), (double)class_23382.method_10260());
            class_310.method_1551().method_1541().method_3355(bs, class_23382, (class_1920)mb, ms, buffer, false, RAND);
            ms.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTileEntityRenderPass(AbstractMultiblock mb, Iterable<? extends class_2338> blocks, class_4597 buffers, class_1162 eye) {
        class_4587 ms = new class_4587();
        for (class_2338 class_23382 : blocks) {
            class_2586 te = mb.method_8321(class_23382);
            if (te == null || this.erroredTiles.contains(te)) continue;
            te.method_11009((class_1937)this.mc.field_1687, class_23382);
            ((MixinBlockEntity)te).setCachedState(mb.method_8320(class_23382));
            ms.method_22903();
            ms.method_22904((double)class_23382.method_10263(), (double)class_23382.method_10264(), (double)class_23382.method_10260());
            try {
                class_827 renderer = class_824.field_4346.method_3550(te);
                if (renderer == null) continue;
                renderer.method_3569(te, ClientTicker.partialTicks, ms, buffers, 0xF000F0, class_4608.field_21444);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                Patchouli.LOGGER.error("An exception occured rendering tile entity", (Throwable)e);
            }
            finally {
                ms.method_22909();
            }
        }
    }
}

