/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageEntity;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.EntityUtil;

public class ComponentEntity
extends TemplateComponent {
    @SerializedName(value="entity")
    public String entityId;
    @SerializedName(value="render_size")
    float renderSize = 100.0f;
    boolean rotate = true;
    @SerializedName(value="default_rotation")
    float defaultRotation = -45.0f;
    transient boolean errored;
    transient class_1297 entity;
    transient Function<class_1937, class_1297> creator;
    transient float renderScale;
    transient float offset;

    @Override
    public void build(BookPage page, BookEntry entry, int pageNum) {
        this.creator = EntityUtil.loadEntity(this.entityId);
    }

    @Override
    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.loadEntity((class_1937)page.mc.field_1687);
    }

    @Override
    public void render(BookPage page, int mouseX, int mouseY, float pticks) {
        if (this.errored) {
            page.fontRenderer.method_1720(class_1074.method_4662((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), (float)this.x, (float)this.y, 0xFF0000);
        }
        if (this.entity != null) {
            this.renderEntity((class_1937)page.mc.field_1687, this.rotate ? ClientTicker.total : this.defaultRotation);
        }
    }

    @Override
    public void onVariablesAvailable(Function<String, String> lookup) {
        super.onVariablesAvailable(lookup);
        this.entityId = lookup.apply(this.entityId);
    }

    private void renderEntity(class_1937 world, float rotation) {
        PageEntity.renderEntity(this.entity, world, this.x, this.y, rotation, this.renderScale, this.offset);
    }

    private void loadEntity(class_1937 world) {
        if (!(this.errored || this.entity != null && this.entity.method_5805())) {
            try {
                this.entity = this.creator.apply(world);
                float width = this.entity.method_17681();
                float height = this.entity.method_17682();
                float entitySize = width;
                if (width < height) {
                    entitySize = height;
                }
                entitySize = Math.max(1.0f, entitySize);
                this.renderScale = this.renderSize / entitySize * 0.8f;
                this.offset = Math.max(height, entitySize) * 0.5f;
            }
            catch (Exception e) {
                this.errored = true;
                Patchouli.LOGGER.error("Failed to load entity", (Throwable)e);
            }
        }
    }
}

