/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import vazkii.patchouli.common.base.Patchouli;

public class PatchouliConfig {
    public static Optional<Boolean> disableAdvancementLocking = Optional.of(false);
    public static Optional<List<String>> noAdvancementBooks = Optional.of(Collections.emptyList());
    public static Optional<Boolean> testingMode = Optional.of(false);
    public static Optional<String> inventoryButtonBook = Optional.of("");
    public static Optional<Boolean> useShiftForQuickLookup = Optional.of(false);
    private static final Map<String, Boolean> CONFIG_FLAGS = new HashMap<String, Boolean>();

    public static void setup() {
    }

    public static void reloadFlags() {
        CONFIG_FLAGS.clear();
        Collection mods = FabricLoader.getInstance().getAllMods();
        for (ModContainer info : mods) {
            PatchouliConfig.setFlag("mod:" + info.getMetadata().getId(), true);
        }
        PatchouliConfig.setFlag("debug", Patchouli.debug);
        PatchouliConfig.setFlag("advancements_disabled", disableAdvancementLocking.get());
        PatchouliConfig.setFlag("testing_mode", testingMode.get());
        for (String book : noAdvancementBooks.get()) {
            PatchouliConfig.setFlag("advancements_disabled_" + book, true);
        }
    }

    public static boolean getConfigFlag(String name) {
        Boolean b;
        if (name.startsWith("&")) {
            return PatchouliConfig.getConfigFlagAND(name.replaceAll("[&|]", "").split(","));
        }
        if (name.startsWith("|")) {
            return PatchouliConfig.getConfigFlagOR(name.replaceAll("[&|]", "").split(","));
        }
        boolean target = true;
        if (name.startsWith("!")) {
            name = name.substring(1);
            target = false;
        }
        if ((b = CONFIG_FLAGS.get(name = name.trim().toLowerCase(Locale.ROOT))) == null) {
            Patchouli.LOGGER.warn("Queried for unknown config flag: {}", (Object)name);
            return false;
        }
        return b == target;
    }

    public static boolean getConfigFlagAND(String[] tokens) {
        for (String s : tokens) {
            if (PatchouliConfig.getConfigFlag(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean getConfigFlagOR(String[] tokens) {
        for (String s : tokens) {
            if (!PatchouliConfig.getConfigFlag(s)) continue;
            return true;
        }
        return false;
    }

    public static void setFlag(String flag, boolean value) {
        CONFIG_FLAGS.put(flag.trim().toLowerCase(Locale.ROOT), value);
    }
}

