/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.world.level.ColorResolver;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.util.RotationUtil;

public abstract class AbstractMultiblock
implements IMultiblock,
class_1920 {
    public class_2960 id;
    protected int offX;
    protected int offY;
    protected int offZ;
    protected int viewOffX;
    protected int viewOffY;
    protected int viewOffZ;
    private boolean symmetrical;
    class_1937 world;
    private final transient Map<class_2338, class_2586> teCache = new HashMap<class_2338, class_2586>();

    @Override
    public IMultiblock offset(int x, int y, int z) {
        return this.setOffset(this.offX + x, this.offY + y, this.offZ + z);
    }

    public IMultiblock setOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
        return this.setViewOffset(x, y, z);
    }

    void setViewOffset() {
        this.setViewOffset(this.offX, this.offY, this.offZ);
    }

    @Override
    public IMultiblock offsetView(int x, int y, int z) {
        return this.setViewOffset(this.viewOffX + x, this.viewOffY + y, this.viewOffZ + z);
    }

    public IMultiblock setViewOffset(int x, int y, int z) {
        this.viewOffX = x;
        this.viewOffY = y;
        this.viewOffZ = z;
        return this;
    }

    @Override
    public IMultiblock setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    @Override
    public class_2960 getID() {
        return this.id;
    }

    @Override
    public IMultiblock setId(class_2960 res) {
        this.id = res;
        return this;
    }

    @Override
    public void place(class_1937 world, class_2338 pos, class_2470 rotation) {
        this.setWorld(world);
        ((Collection)this.simulate(world, pos, rotation, false).getSecond()).forEach(r -> {
            class_2338 placePos = r.getWorldPosition();
            class_2680 targetState = r.getStateMatcher().getDisplayedState((int)world.method_8532()).method_11626(rotation);
            class_2248 targetBlock = targetState.method_11614();
            if (!targetBlock.method_9500(targetState) && targetState.method_11591((class_4538)world, placePos) && world.method_8320(placePos).method_11620().method_15800()) {
                world.method_8501(placePos, targetState);
            }
        });
    }

    @Override
    public class_2470 validate(class_1937 world, class_2338 pos) {
        if (this.isSymmetrical() && this.validate(world, pos, class_2470.field_11467)) {
            return class_2470.field_11467;
        }
        for (class_2470 rot : class_2470.values()) {
            if (!this.validate(world, pos, rot)) continue;
            return rot;
        }
        return null;
    }

    @Override
    public boolean validate(class_1937 world, class_2338 pos, class_2470 rotation) {
        this.setWorld(world);
        Pair<class_2338, Collection<IMultiblock.SimulateResult>> sim = this.simulate(world, pos, rotation, false);
        return ((Collection)sim.getSecond()).stream().allMatch(r -> {
            class_2338 checkPos = r.getWorldPosition();
            TriPredicate<class_1922, class_2338, class_2680> pred = r.getStateMatcher().getStatePredicate();
            class_2680 state = world.method_8320(checkPos).method_11626(RotationUtil.fixHorizontal(rotation));
            return pred.test((class_1922)world, checkPos, state);
        });
    }

    @Override
    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setWorld(class_1937 world) {
        this.world = world;
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        class_2680 state = this.method_8320(pos);
        if (state.method_11614().method_9570()) {
            return this.teCache.computeIfAbsent(pos.method_10062(), p -> ((class_2343)state.method_11614()).method_10123((class_1922)this.world));
        }
        return null;
    }

    public class_3610 method_8316(class_2338 pos) {
        return class_3612.field_15906.method_15785();
    }

    @Override
    public abstract class_2382 getSize();

    public class_3568 method_22336() {
        return null;
    }

    public int method_23752(class_2338 pos, ColorResolver color) {
        return color.getColor(class_1972.field_9451, (double)pos.method_10263(), (double)pos.method_10260());
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        return 15;
    }

    public int method_22335(class_2338 pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }
}

