/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.EntityUtil;

public class PageEntity
extends PageWithText {
    @SerializedName(value="entity")
    public String entityId;
    float scale = 1.0f;
    @SerializedName(value="offset")
    float extraOffset = 0.0f;
    String name;
    boolean rotate = true;
    @SerializedName(value="default_rotation")
    float defaultRotation = -45.0f;
    transient boolean errored;
    transient Entity entity;
    transient Function<World, Entity> creator;
    transient float renderScale;
    transient float offset;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.creator = EntityUtil.loadEntity(this.entityId);
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.loadEntity((World)parent.getMinecraft().field_71441_e);
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(this.book, x, y, 405, 149, 106, 106);
        this.parent.drawCenteredStringNoShadow(this.name, 58, 0, this.book.headerColor);
        if (this.errored) {
            this.fontRenderer.func_175063_a(I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), 58.0f, 60.0f, 0xFF0000);
        }
        if (this.entity != null) {
            this.renderEntity((World)this.parent.getMinecraft().field_71441_e, this.rotate ? ClientTicker.total : this.defaultRotation);
        }
        super.render(mouseX, mouseY, pticks);
    }

    private void renderEntity(World world, float rotation) {
        PageEntity.renderEntity(this.entity, world, 58.0f, 60.0f, rotation, this.renderScale, this.offset);
    }

    public static void renderEntity(Entity entity, World world, float x, float y, float rotation, float renderScale, float offset) {
        entity.field_70170_p = world;
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        MatrixStack matrix = new MatrixStack();
        matrix.func_227861_a_((double)x, (double)y, 50.0);
        matrix.func_227862_a_(renderScale, renderScale, renderScale);
        matrix.func_227861_a_(0.0, (double)offset, 0.0);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        EntityRendererManager erd = Minecraft.func_71410_x().func_175598_ae();
        IRenderTypeBuffer.Impl immediate = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        erd.func_178633_a(false);
        erd.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (IRenderTypeBuffer)immediate, 0xF000F0);
        erd.func_178633_a(true);
        immediate.func_228461_a_();
        RenderSystem.popMatrix();
    }

    private void loadEntity(World world) {
        if (!(this.errored || this.entity != null && this.entity.func_70089_S())) {
            try {
                this.entity = this.creator.apply(world);
                float width = this.entity.func_213311_cf();
                float height = this.entity.func_213302_cg();
                float entitySize = width;
                if (width < height) {
                    entitySize = height;
                }
                entitySize = Math.max(1.0f, entitySize);
                this.renderScale = 100.0f / entitySize * 0.8f * this.scale;
                this.offset = Math.max(height, entitySize) * 0.5f + this.extraOffset;
                if (this.name == null || this.name.isEmpty()) {
                    this.name = this.entity.func_200200_C_().func_150254_d();
                }
            }
            catch (Exception e) {
                this.errored = true;
                Patchouli.LOGGER.error("Failed to load entity", (Throwable)e);
            }
        }
    }
}

