/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;
import vazkii.patchouli.api.IMultiblock;

public abstract class AbstractMultiblock
implements IMultiblock,
ILightReader {
    public ResourceLocation id;
    protected int offX;
    protected int offY;
    protected int offZ;
    protected int viewOffX;
    protected int viewOffY;
    protected int viewOffZ;
    private boolean symmetrical;
    World world;
    private final transient Map<BlockPos, TileEntity> teCache = new HashMap<BlockPos, TileEntity>();

    @Override
    public IMultiblock offset(int x, int y, int z) {
        return this.setOffset(this.offX + x, this.offY + y, this.offZ + z);
    }

    public IMultiblock setOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
        return this.setViewOffset(x, y, z);
    }

    void setViewOffset() {
        this.setViewOffset(this.offX, this.offY, this.offZ);
    }

    @Override
    public IMultiblock offsetView(int x, int y, int z) {
        return this.setViewOffset(this.viewOffX + x, this.viewOffY + y, this.viewOffZ + z);
    }

    public IMultiblock setViewOffset(int x, int y, int z) {
        this.viewOffX = x;
        this.viewOffY = y;
        this.viewOffZ = z;
        return this;
    }

    @Override
    public IMultiblock setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    public IMultiblock setId(ResourceLocation res) {
        this.id = res;
        return this;
    }

    @Override
    public void place(World world, BlockPos pos, Rotation rotation) {
        this.setWorld(world);
        ((Collection)this.simulate(world, pos, rotation, false).getSecond()).forEach(r -> {
            BlockPos placePos = r.getWorldPosition();
            BlockState targetState = r.getStateMatcher().getDisplayedState((int)world.func_72820_D()).func_185907_a(rotation);
            Block targetBlock = targetState.func_177230_c();
            if (!targetBlock.isAir(targetState, (IBlockReader)world, placePos) && targetState.func_196955_c((IWorldReader)world, placePos) && world.func_180495_p(placePos).func_185904_a().func_76222_j()) {
                world.func_175656_a(placePos, targetState);
            }
        });
    }

    @Override
    public Rotation validate(World world, BlockPos pos) {
        if (this.isSymmetrical() && this.validate(world, pos, Rotation.NONE)) {
            return Rotation.NONE;
        }
        for (Rotation rot : Rotation.values()) {
            if (!this.validate(world, pos, rot)) continue;
            return rot;
        }
        return null;
    }

    @Override
    public boolean validate(World world, BlockPos pos, Rotation rotation) {
        this.setWorld(world);
        Pair<BlockPos, Collection<IMultiblock.SimulateResult>> sim = this.simulate(world, pos, rotation, false);
        return ((Collection)sim.getSecond()).stream().allMatch(r -> r.test(world, rotation));
    }

    @Override
    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        BlockState state = this.func_180495_p(pos);
        if (state.func_177230_c().hasTileEntity(state)) {
            return this.teCache.computeIfAbsent(pos.func_185334_h(), p -> state.func_177230_c().createTileEntity(state, (IBlockReader)this.world));
        }
        return null;
    }

    public IFluidState func_204610_c(BlockPos pos) {
        return Fluids.field_204541_a.func_207188_f();
    }

    public WorldLightManager func_225524_e_() {
        return null;
    }

    public int func_225525_a_(BlockPos pos, ColorResolver color) {
        return color.getColor(Biomes.field_76772_c, (double)pos.func_177958_n(), (double)pos.func_177952_p());
    }

    public int func_226658_a_(LightType type, BlockPos pos) {
        return 15;
    }

    public int func_226659_b_(BlockPos pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }
}

