/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.network.message;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.patchouli.client.book.ClientBookRegistry;

public class MessageOpenBookGui {
    private final ResourceLocation book;
    @Nullable
    private final ResourceLocation entry;
    private final int page;

    public MessageOpenBookGui(PacketBuffer buf) {
        this.book = buf.func_192575_l();
        String tmp = buf.func_218666_n();
        this.entry = tmp.isEmpty() ? null : ResourceLocation.func_208304_a((String)tmp);
        this.page = buf.func_150792_a();
    }

    public MessageOpenBookGui(ResourceLocation book, @Nullable ResourceLocation entry) {
        this(book, entry, 0);
    }

    public MessageOpenBookGui(ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        this.book = book;
        this.entry = entry;
        this.page = page;
    }

    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.book);
        buf.func_180714_a(this.entry == null ? "" : this.entry.toString());
        buf.func_150787_b(this.page);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide().isClient()) {
            context.get().enqueueWork(() -> ClientBookRegistry.INSTANCE.displayBookGui(this.book, this.entry, this.page));
            return true;
        }
        return false;
    }
}

