/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import java.io.File;
import java.io.FileInputStream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.BookRegistry;

public class BookFolderLoader {
    public static File loadDir;

    private static void setup() {
        loadDir = new File("patchouli_books");
        if (!loadDir.exists()) {
            loadDir.mkdir();
        } else if (!loadDir.isDirectory()) {
            throw new RuntimeException(loadDir.getAbsolutePath() + " is a file, not a folder, aborting. Please delete this file or move it elsewhere if it has important contents.");
        }
    }

    public static void findBooks() {
        if (loadDir == null) {
            BookFolderLoader.setup();
        }
        ModContainer self = (ModContainer)FabricLoader.getInstance().getModContainer("patchouli").get();
        File[] subdirs = loadDir.listFiles(File::isDirectory);
        if (subdirs == null) {
            Patchouli.LOGGER.warn("Failed to list external books in {}, not loading external books", (Object)loadDir.getAbsolutePath());
            return;
        }
        for (File dir : subdirs) {
            class_2960 res;
            try {
                res = new class_2960("patchouli", dir.getName());
            }
            catch (class_151 ex) {
                Patchouli.LOGGER.error("Invalid external book folder name {}, skipping", (Object)dir.getName(), (Object)ex);
                continue;
            }
            File bookJson = new File(dir, "book.json");
            try (FileInputStream stream = new FileInputStream(bookJson);){
                BookRegistry.INSTANCE.loadBook(self, res, stream, true);
            }
            catch (Exception e) {
                Patchouli.LOGGER.error("Failed to load external book json from {}, skipping", (Object)bookJson, (Object)e);
            }
        }
    }
}

