/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairBlacklist;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairHelper;
import com.blakebr0.pickletweaks.registry.ModRecipeSerializers;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GridRepairRecipe
extends ShapelessRecipe {
    public GridRepairRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, output, inputs);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        if (!((Boolean)ModConfigs.GRID_REPAIR_ENABLED.get()).booleanValue()) {
            return ItemStack.field_190927_a;
        }
        ItemStack tool = ItemStack.field_190927_a;
        boolean foundTool = false;
        NonNullList inputs = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            ItemStack newSlotStack = StackHelper.withSize((ItemStack)slotStack.func_77946_l(), (int)1, (boolean)false);
            if (!foundTool && newSlotStack.func_77984_f()) {
                tool = newSlotStack;
                foundTool = true;
                continue;
            }
            inputs.add((Object)newSlotStack);
        }
        if (tool.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!tool.func_77951_h()) {
            return ItemStack.field_190927_a;
        }
        if (inputs.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (tool.func_77973_b().hasContainerItem(tool)) {
            return ItemStack.field_190927_a;
        }
        if (GridRepairBlacklist.isBlacklisted(tool.func_77973_b())) {
            return ItemStack.field_190927_a;
        }
        int repairCost = (Integer)ModConfigs.GRID_REPAIR_COST.get();
        boolean cheaperShovel = (Boolean)ModConfigs.GRID_REPAIR_CHEAP_SHOVEL.get();
        if (cheaperShovel && tool.func_77973_b() instanceof ShovelItem) {
            repairCost = Math.max(1, repairCost / 2);
        }
        int damage = tool.func_77958_k() / repairCost;
        double matCount = 0.0;
        boolean maxed = false;
        for (ItemStack mat : inputs) {
            if (maxed) {
                return ItemStack.field_190927_a;
            }
            if (!mat.hasContainerItem()) {
                double matValue = GridRepairHelper.getMaterialValue(tool, mat);
                if (matValue == 0.0) {
                    return ItemStack.field_190927_a;
                }
                matCount += matValue;
                if (!((double)tool.func_77952_i() - (double)damage * matCount <= 0.0)) continue;
                maxed = true;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        tool.func_196085_b(tool.func_77952_i() - (int)((double)damage * matCount));
        return tool;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        return !this.func_77572_b(inv).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.CRAFTING_GRID_REPAIR;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<GridRepairRecipe> {
        public GridRepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new GridRepairRecipe(recipeId, "", ItemStack.field_190927_a, (NonNullList<Ingredient>)NonNullList.func_191196_a());
        }

        public GridRepairRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new GridRepairRecipe(recipeId, "", ItemStack.field_190927_a, (NonNullList<Ingredient>)NonNullList.func_191196_a());
        }

        public void write(PacketBuffer buffer, GridRepairRecipe recipe) {
        }
    }
}

