/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.ItemAnalyser;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.tileentity.TileEntityCrops;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockCropBase
extends BlockContainer {
    public static final IntegerProperty GROWSTATE = IntegerProperty.func_177719_a((String)"growstate", (int)0, (int)7);
    private String entryName;

    public BlockCropBase(String entryName) {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(0.5f));
        this.entryName = entryName;
        this.setRegistryName(entryName + "_crop");
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityCrops();
    }

    public void updateCrop(World world, BlockPos pos, HashMapCropTraits traits) {
        block3: {
            block2: {
                IBlockState state = world.func_180495_p(pos);
                int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
                if (growstate >= 7) break block2;
                if (!this.canGrow(world, pos, traits)) break block3;
                world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(Integer.valueOf(growstate) + 1)));
                break block3;
            }
            List<BlockPos> neighborpos = this.getNeighborBlockPosRandom(pos);
            for (BlockPos blockpos : neighborpos) {
                if (world.func_180495_p(blockpos).func_177230_c() != ModBlocks.CROPBARS) continue;
                List<BlockPos> cropbarneighbors = this.getNeighborBlockPosRandomExeptOne(blockpos, pos);
                for (BlockPos possiblePartner : cropbarneighbors) {
                    if (!(world.func_180495_p(possiblePartner).func_177230_c() instanceof BlockCropBase) || !(world.func_175625_s(possiblePartner) instanceof TileEntityCrops)) continue;
                    HashMapCropTraits partnertraits = ((TileEntityCrops)world.func_175625_s(possiblePartner)).getTraits();
                    world.func_175656_a(blockpos, this.func_176223_P());
                    if (!(world.func_175625_s(blockpos) instanceof TileEntityCrops) || !(world.func_175625_s(pos) instanceof TileEntityCrops)) continue;
                    ((TileEntityCrops)world.func_175625_s(blockpos)).setTraits(((TileEntityCrops)world.func_175625_s(pos)).getTraits().calculateNewTraits(partnertraits));
                    break;
                }
                if (world.func_180495_p(blockpos).func_177230_c() instanceof BlockCropBase) break;
                world.func_175656_a(blockpos, this.func_176223_P());
                if (!(world.func_175625_s(blockpos) instanceof TileEntityCrops) || !(world.func_175625_s(pos) instanceof TileEntityCrops)) break;
                ((TileEntityCrops)world.func_175625_s(blockpos)).setTraits(((TileEntityCrops)world.func_175625_s(pos)).getTraits().copy());
                break;
            }
        }
    }

    public void updateCreative(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        if (growstate < 7) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(7)));
        }
    }

    private List<BlockPos> getNeighborBlockPosRandom(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177976_e());
        Collections.shuffle(neighbors);
        return neighbors;
    }

    private List<BlockPos> getNeighborBlockPosRandomExeptOne(BlockPos pos, BlockPos exept) {
        List<BlockPos> neighbors = this.getNeighborBlockPosRandom(pos);
        neighbors.remove(exept);
        return neighbors;
    }

    private boolean canGrow(World world, BlockPos pos, HashMapCropTraits traits) {
        if (!this.enoughtLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
            return false;
        }
        if (!this.enoughtWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
            return false;
        }
        if (!this.rightSoil(world, pos, traits.getType())) {
            return false;
        }
        return this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE));
    }

    public String[] canGrowString(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        String[] messages = new String[10];
        if (te instanceof TileEntityCrops) {
            HashMapCropTraits traits = ((TileEntityCrops)te).getTraits();
            if (!this.enoughtLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
                messages[1] = "Not enought light";
            }
            if (!this.enoughtWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
                messages[2] = "Not enought water";
            }
            if (!this.rightSoil(world, pos, traits.getType())) {
                messages[3] = "Not right soil";
            }
            if (!this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE))) {
                messages[4] = "Not right temperature";
            }
        } else {
            messages[0] = "error";
        }
        return messages;
    }

    public boolean enoughtLight(World world, BlockPos pos, int lightsensitivity) {
        if (!world.func_205050_e(pos, 1)) {
            return false;
        }
        return world.func_201669_a(pos, 0) >= 14 - lightsensitivity;
    }

    public boolean enoughtWater(World world, BlockPos pos, int waterSensitivity) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1 * (waterSensitivity + 1), 0, -1 * (waterSensitivity + 1)), (BlockPos)pos.func_177982_a(waterSensitivity + 1, -1, waterSensitivity + 1))) {
            if (world.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public boolean rightSoil(World world, BlockPos pos, String name) {
        ItemStack stack = PlantTechMain.croplist.getEntryByName(name).getSoil();
        if (stack.func_190926_b()) {
            return true;
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            return state.func_177230_c() == block;
        }
        return false;
    }

    public boolean rightTemperature(World world, BlockPos pos, String name, int tolerance) {
        EnumTemperature temp = PlantTechMain.croplist.getEntryByName(name).getTemperature();
        return temp.inRange(world.func_180494_b(pos).func_185353_n(), tolerance);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{GROWSTATE});
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCrops) {
            ((TileEntityCrops)te).addDrops(drops, growstate);
            drops.add((Object)new ItemStack((IItemProvider)ModBlocks.CROPBARS));
        } else {
            super.getDrops(state, drops, world, pos, fortune);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        if (willHarvest && !player.func_184812_l_()) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 1);
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        if (growstate > 6 && hand.equals((Object)EnumHand.MAIN_HAND) && !worldIn.field_72995_K) {
            ItemStack holdItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (!holdItem.func_190926_b() && holdItem.func_77973_b() instanceof ItemAnalyser) {
                return super.func_196250_a(state, worldIn, pos, player, hand, side, hitX, hitY, hitZ);
            }
            NonNullList drops = NonNullList.func_191196_a();
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileEntityCrops) {
                ((TileEntityCrops)te).dropsRemoveOneSeed((NonNullList<ItemStack>)drops, growstate);
                for (ItemStack stack : drops) {
                    BlockCropBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                }
                worldIn.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(0)));
            }
        }
        return super.func_196250_a(state, worldIn, pos, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_200124_e(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.MODEL;
    }

    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public static boolean isOpaque(VoxelShape shape) {
        return true;
    }

    public static class ColorHandler
    implements IBlockColor {
        public int getColor(IBlockState state, IWorldReaderBase world, BlockPos pos, int tintindex) {
            if (tintindex == 0) {
                return PlantTechMain.croplist.getEntryByName(((BlockCropBase)state.func_177230_c()).getEntryName()).getSeedColor();
            }
            return -1;
        }
    }
}

