/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.machines;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.BlockBase;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.cable.TileEntityCable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IExtendedState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.energy.CapabilityEnergy;

public class BlockCable
extends BlockBase {
    public static final IUnlistedProperty<Integer> UP = new Properties.PropertyAdapter((IProperty)IntegerProperty.func_177719_a((String)"up", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> NORTH = new Properties.PropertyAdapter((IProperty)IntegerProperty.func_177719_a((String)"north", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> WEST = new Properties.PropertyAdapter((IProperty)IntegerProperty.func_177719_a((String)"west", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> SOUTH = new Properties.PropertyAdapter((IProperty)IntegerProperty.func_177719_a((String)"south", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> EAST = new Properties.PropertyAdapter((IProperty)IntegerProperty.func_177719_a((String)"east", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> DOWN = new Properties.PropertyAdapter((IProperty)IntegerProperty.func_177719_a((String)"down", (int)0, (int)4));
    protected static final AxisAlignedBB[] AABB_CONNECTIONS = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625), new AxisAlignedBB(0.375, 0.875, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.125), new AxisAlignedBB(0.375, 0.375, 0.875, 0.625, 0.625, 1.0), new AxisAlignedBB(0.0, 0.375, 0.375, 0.125, 0.625, 0.625), new AxisAlignedBB(0.875, 0.375, 0.375, 1.0, 0.625, 0.625)};

    public BlockCable() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f), "cable", PlantTechMain.groupmachines, true);
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityCable te;
        Integer result;
        if (!worldIn.field_72995_K && hand.equals((Object)EnumHand.MAIN_HAND) && player.func_184614_ca().func_77973_b().equals((Object)ModItems.WRENCH) && (result = Integer.valueOf(this.getConnectionLookedOn(worldIn, pos, player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a(5.0))))) != -1 && (te = this.getTECable(worldIn, pos)) != null) {
            te.rotateConnection(result);
        }
        return super.func_196250_a(state, worldIn, pos, player, hand, side, hitX, hitY, hitZ);
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.CABLE);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)ModBlocks.CABLE);
    }

    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        TileEntityCable te = this.getTECable(worldIn, pos);
        if (te != null) {
            te.initCable(state);
        }
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityCable();
    }

    @Override
    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this, new Item.Properties().func_200916_a(PlantTechMain.groupmain)).setRegistryName("cable");
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCable) {
            ((TileEntityCable)te).deleteCable();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int getConnectionLookedOn(World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        HashMap<Integer, AxisAlignedBB> boxes = this.getCollisionBoxListConnectionsList(worldIn, pos);
        HashMap<Integer, RayTraceResult> rayTraces = this.rayTraceList(pos, start, end, boxes);
        double d1 = 0.0;
        int returnval = -1;
        for (Map.Entry<Integer, RayTraceResult> entry : rayTraces.entrySet()) {
            double d0 = entry.getValue().field_72307_f.func_72436_e(end);
            if (!(d0 > d1)) continue;
            d1 = d0;
            returnval = entry.getKey();
        }
        return returnval;
    }

    private HashMap<Integer, AxisAlignedBB> getCollisionBoxListConnectionsList(World world, BlockPos pos) {
        HashMap<Integer, AxisAlignedBB> list = new HashMap<Integer, AxisAlignedBB>();
        TileEntityCable te = this.getTECable(world, pos);
        if (te != null) {
            for (EnumFacing facing : EnumFacing.values()) {
                if (te.getConnection(facing) <= 1) continue;
                list.put(facing.func_176745_a(), AABB_CONNECTIONS[facing.func_176745_a()]);
            }
        }
        return list;
    }

    @Nullable
    protected HashMap<Integer, RayTraceResult> rayTraceList(BlockPos pos, Vec3d start, Vec3d end, HashMap<Integer, AxisAlignedBB> boxes) {
        HashMap<Integer, RayTraceResult> list = new HashMap<Integer, RayTraceResult>();
        boxes.forEach((k, v) -> {
            Vec3d vec3d1;
            Vec3d vec3d = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            RayTraceResult raytraceresult = v.func_72327_a(vec3d, vec3d1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            if (raytraceresult != null) {
                list.put((Integer)k, new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos));
            }
        });
        return list;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockReader reader, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            TileEntity te = reader.func_175625_s(pos);
            if (te instanceof TileEntityCable) {
                TileEntityCable tec = (TileEntityCable)te;
                return (IBlockState)((IExtendedState)((IExtendedState)((IExtendedState)((IExtendedState)((IExtendedState)extState.withProperty(UP, (Object)((TileEntityCable)te).getConnection(EnumFacing.UP))).withProperty(DOWN, (Object)((TileEntityCable)te).getConnection(EnumFacing.DOWN))).withProperty(EAST, (Object)((TileEntityCable)te).getConnection(EnumFacing.EAST))).withProperty(WEST, (Object)((TileEntityCable)te).getConnection(EnumFacing.WEST))).withProperty(NORTH, (Object)((TileEntityCable)te).getConnection(EnumFacing.NORTH))).withProperty(SOUTH, (Object)((TileEntityCable)te).getConnection(EnumFacing.SOUTH));
            }
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing neighborfacing = null;
        for (EnumFacing facing : EnumFacing.values()) {
            if (!pos.func_177972_a(facing).equals((Object)fromPos)) continue;
            neighborfacing = facing;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && neighborfacing != null && (te instanceof TileEntityCable || te.getCapability(CapabilityEnergy.ENERGY, neighborfacing).isPresent())) {
            ((TileEntityCable)te).checkConnections();
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    private TileEntityCable getTECable(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCable) {
            return (TileEntityCable)te;
        }
        return null;
    }
}

