/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.enums;

import net.minecraft.util.text.TextComponentTranslation;

public enum EnumTemperature {
    EXTREME_COLD(0, -1.0f, 0.0f),
    COLD(1, 0.0f, 0.5f),
    NORMAL(2, 0.5f, 1.0f),
    WARM(3, 1.0f, 1.5f),
    EXTREME_WARM(4, 1.5f, 2.5f);

    private int id;
    private float min;
    private float max;

    private EnumTemperature(int id, float min, float max) {
        this.id = id;
        this.min = min;
        this.max = max;
    }

    public static EnumTemperature byValue(float value) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!(temp.min <= value) || !(temp.max > value)) continue;
            return temp;
        }
        return EXTREME_WARM;
    }

    public static EnumTemperature byId(int id) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (temp.id != id) continue;
            return temp;
        }
        return NORMAL;
    }

    public static EnumTemperature byName(String name) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!temp.name().equals(name)) continue;
            return temp;
        }
        return NORMAL;
    }

    public String getDisplayString() {
        return new TextComponentTranslation("temp." + this.name(), new Object[0]).func_150261_e();
    }

    public boolean inRange(float value, int tolerance) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (this.id - tolerance > temp.id || temp.id > this.id + tolerance || !(temp.min <= value) || !(temp.max > value)) continue;
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }
}

