/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.fluids;

import net.minecraft.nbt.NBTTagCompound;

public class TempFluidTank {
    private int capacity;
    private int biomass;

    public TempFluidTank(int capacity, int biomass) {
        this.capacity = capacity;
        this.biomass = biomass;
    }

    public TempFluidTank(int capacity) {
        this.capacity = capacity;
        this.biomass = 0;
    }

    public int receive(int maxReceive) {
        int space = this.capacity - this.biomass;
        if (space >= maxReceive) {
            this.biomass += maxReceive;
            return maxReceive;
        }
        this.biomass = this.capacity;
        return space;
    }

    public int extract(int maxExtract) {
        if (this.biomass >= maxExtract) {
            this.biomass -= maxExtract;
            return maxExtract;
        }
        this.biomass = 0;
        return this.biomass;
    }

    public void setCapacity(int value) {
        this.capacity = value;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setBiomass(int value) {
        this.biomass = value;
    }

    public int getBiomass() {
        return this.biomass;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.capacity = nbt.func_74762_e("tankcapacity");
        this.biomass = nbt.func_74762_e("biomass");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbtList = new NBTTagCompound();
        nbtList.func_74768_a("tankcapacity", this.capacity);
        nbtList.func_74768_a("biomass", this.biomass);
        return nbtList;
    }
}

