/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import net.kaneka.planttech2.items.ItemGuide;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiGuideBase
extends GuiScreen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2:textures/gui/plantencyclopeadia_big.png");
    protected int xSize = 512;
    protected int ySize = 196;
    protected int guiLeft;
    protected int guiTop;
    protected int scrollMax;
    protected int scrollPos = 0;
    protected int fadeInTimer = 50;
    protected int selectedId;
    protected boolean canscroll;

    public GuiGuideBase(int scrollMax, boolean canscroll) {
        this.scrollMax = scrollMax;
        this.canscroll = canscroll;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof ItemGuide) {
            Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_196085_b(1);
        }
        this.selectedId = -1;
        this.guiLeft = (this.field_146294_l - 400) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    protected void updateButtons() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        if (this.fadeInTimer > 0) {
            --this.fadeInTimer;
            this.drawFadeInEffect();
        } else {
            this.drawBackground();
            this.drawForeground();
            this.drawButtons(mouseX, mouseY, partialTicks);
            this.drawStrings();
            this.drawTooltips(mouseX, mouseY);
        }
    }

    private void drawButtons(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_194828_a(mouseX, mouseY, partialTicks);
        }
        for (int j = 0; j < this.field_146293_o.size(); ++j) {
            ((GuiLabel)this.field_146293_o.get(j)).func_194997_a(mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground() {
        Gui.func_146110_a((int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)0.0f, (int)300, (int)this.ySize, (float)512.0f, (float)512.0f);
        Gui.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (float)512.0f, (float)512.0f);
    }

    protected void drawForeground() {
    }

    private void drawFadeInEffect() {
        float percentage = 1.0f - (float)this.fadeInTimer / 50.0f;
        Gui.func_146110_a((int)(this.guiLeft + 100), (int)this.guiTop, (float)((float)this.xSize - 300.0f * percentage), (float)0.0f, (int)((int)(300.0f * percentage)), (int)this.ySize, (float)512.0f, (float)512.0f);
        Gui.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (float)512.0f, (float)512.0f);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_) {
        if (this.canscroll && p_mouseScrolled_1_ != 0.0) {
            this.scrollPos += p_mouseScrolled_1_ > 0.0 ? -1 : 1;
            this.scrollPos = Math.max(0, this.scrollPos);
            this.scrollPos = Math.min(this.scrollMax, this.scrollPos);
            this.updateButtons();
        }
        return super.mouseScrolled(p_mouseScrolled_1_);
    }

    protected void drawStrings() {
    }

    protected String translateUnformated(String name) {
        return new TextComponentTranslation(name, new Object[0]).func_150261_e();
    }

    protected void drawCenteredString(String string, int posX, int posY) {
        this.field_146289_q.func_211126_b(string, (float)(posX - this.field_146289_q.func_78256_a(string) / 2), (float)posY, Integer.parseInt("00e803", 16));
    }

    public void renderItem(ItemStack itemstack, int x, int y) {
        this.field_146296_j.func_180450_b(itemstack, this.guiLeft + x, this.guiTop + y);
    }

    public void drawTooltip(String lines, int mouseX, int mouseY, int posX, int posY) {
        this.drawTooltip(lines, mouseX, mouseY, posX, posY, 16, 16);
    }

    public void drawTooltip(String lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.guiLeft) && mouseX <= posX + width && mouseY >= (posY += this.guiTop) && mouseY <= posY + height) {
            this.func_146279_a(lines, mouseX, mouseY);
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
    }

    public void func_146281_b() {
        if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof ItemGuide) {
            Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_196085_b(0);
        }
    }
}

