/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.items.ItemBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemBiomassContainer
extends ItemBase {
    private static int capacity = 1000;

    public ItemBiomassContainer() {
        super("biomasscontainer", new Item.Properties().func_200916_a(PlantTechMain.groupmain));
        this.func_185043_a(new ResourceLocation("filled"), (stack, world, player) -> ItemBiomassContainer.getFillLevelModel(stack));
    }

    public static float getFillLevelModel(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            int biomass = nbt.func_74762_e("biomass");
            if (biomass > capacity / 9 * 9) {
                return 9.0f;
            }
            if (biomass > capacity / 9 * 8) {
                return 8.0f;
            }
            if (biomass > capacity / 9 * 7) {
                return 7.0f;
            }
            if (biomass > capacity / 9 * 6) {
                return 6.0f;
            }
            if (biomass > capacity / 9 * 5) {
                return 5.0f;
            }
            if (biomass > capacity / 9 * 4) {
                return 4.0f;
            }
            if (biomass > capacity / 9 * 3) {
                return 3.0f;
            }
            if (biomass > capacity / 9 * 2) {
                return 2.0f;
            }
            if (biomass > capacity / 9 * 1) {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public int getFillLevel(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74762_e("biomass");
        }
        return 0;
    }

    private void setFillLevel(ItemStack stack, int value) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a("biomass", value);
        stack.func_77982_d(nbt);
    }

    public int receiveFillLevel(ItemStack stack, int value) {
        int biomass;
        int space;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if ((space = capacity - (biomass = nbt.func_74762_e("biomass"))) >= value) {
            this.setFillLevel(stack, biomass + value);
            return value;
        }
        this.setFillLevel(stack, capacity);
        return space;
    }

    public int extractFillLevel(ItemStack stack, int value) {
        int biomass;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if ((biomass = nbt.func_74762_e("biomass")) >= value) {
            this.setFillLevel(stack, biomass - value);
            return value;
        }
        this.setFillLevel(stack, 0);
        return biomass;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            tooltip.add((ITextComponent)new TextComponentString(nbt.func_74762_e("biomass") + "/" + capacity));
        } else {
            tooltip.add((ITextComponent)new TextComponentString("0/" + capacity));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

