/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.items.ItemBase;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCropSeed
extends ItemBase {
    private String entryName;

    public ItemCropSeed(String entryName) {
        super(entryName + "_seeds", new Item.Properties().func_200916_a(PlantTechMain.groupseeds));
        this.entryName = entryName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_74767_n("analysed")) {
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.type", new Object[0]).func_150261_e() + ": " + nbt.func_74779_i("type")));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.soil", new Object[0]).func_150261_e() + ": " + this.getSoilString(nbt.func_74779_i("type"))));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.growspeed", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("growspeed")));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.sensitivity", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("sensitivity")));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.needed_lightlevel", new Object[0]).func_150261_e() + ": " + (14 - nbt.func_74762_e("lightsensitivity"))));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.waterrange", new Object[0]).func_150261_e() + ": " + (1 + nbt.func_74762_e("watersensitivity"))));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.temperature", new Object[0]).func_150261_e() + ": " + this.temperatureString(nbt.func_74779_i("type"), nbt.func_74762_e("temperaturetolerance"))));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.productivity", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("productivity")));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.fertility", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("fertility")));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.spreedingspeed", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("spreedingspeed")));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.genestrength", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("genestrength")));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.energyvalue", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("energyvalue") * 20));
            } else {
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.type", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.soil", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.growspeed", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.sensitivity", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.needed_lightlevel", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.waterrange", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.temperaturetolerance", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.productivity", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.fertility", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.spreedingspeed", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.genestrength", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.energyvalue", new Object[0]).func_150261_e() + ": " + new TextComponentTranslation("info.unknown", new Object[0]).func_150261_e()));
            }
        } else {
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.type", new Object[0]).func_150261_e() + ": " + this.entryName));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.soil", new Object[0]).func_150261_e() + ": " + this.getSoilString(this.entryName)));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.growspeed", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.sensitivity", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.needed_lightlevel", new Object[0]).func_150261_e() + ": " + 14));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.waterrange", new Object[0]).func_150261_e() + ": " + 1));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.temperaturetolerance", new Object[0]).func_150261_e() + ": " + this.temperatureString(this.entryName, 0)));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.productivity", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.fertility", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.spreedingspeed", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.genestrength", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.energyvalue", new Object[0]).func_150261_e() + ": " + 20));
        }
    }

    private String temperatureString(String type, int tolerance) {
        if (tolerance == 0) {
            return PlantTechMain.croplist.getEntryByName(type).getTemperature().getDisplayString();
        }
        int id = PlantTechMain.croplist.getEntryByName(type).getTemperature().getId();
        int min = id - tolerance;
        int max = id + tolerance;
        if (min < 0) {
            min = 0;
        }
        if (max > 4) {
            max = 4;
        }
        return EnumTemperature.byId(min).getDisplayString() + " - " + EnumTemperature.byId(max).getDisplayString();
    }

    private String getSoilString(String type) {
        ItemStack soil = PlantTechMain.croplist.getEntryByName(type).getSoil();
        if (soil.func_190926_b()) {
            return " / ";
        }
        return soil.func_200301_q().func_150261_e();
    }

    public static class ColorHandler
    implements IItemColor {
        public int getColor(ItemStack stack, int color) {
            return PlantTechMain.croplist.getEntryByName(((ItemCropSeed)stack.func_77973_b()).getEntryName()).getSeedColor();
        }
    }
}

