/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.blocks.BlockCropBase;
import net.kaneka.planttech2.items.ItemBase;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.TileEntityCrops;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemFertilizer
extends ItemBase {
    public ItemFertilizer(String name, ItemGroup group) {
        super(name, new Item.Properties().func_200916_a(group));
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockCropBase) {
            if (!context.func_195999_j().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            if (field_77697_d.nextFloat() < this.getIncreaseChance(stack.func_77973_b()) && stack.func_77973_b() != ModItems.FERTILIZER_CREATIVE) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntityCrops) {
                    ((BlockCropBase)block).updateCrop(world, pos, ((TileEntityCrops)te).getTraits());
                }
            } else if (stack.func_77973_b() == ModItems.FERTILIZER_CREATIVE) {
                ((BlockCropBase)block).updateCreative(world, pos);
            }
        }
        return super.func_195939_a(context);
    }

    public float getIncreaseChance(Item item) {
        if (item == ModItems.FERTILIZER_TIER_1) {
            return 0.05f;
        }
        if (item == ModItems.FERTILIZER_TIER_2) {
            return 0.15f;
        }
        if (item == ModItems.FERTILIZER_TIER_3) {
            return 0.35f;
        }
        if (item == ModItems.FERTILIZER_TIER_4) {
            return 0.75f;
        }
        if (item == ModItems.FERTILIZER_CREATIVE) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.fertilizer", new Object[0]).func_150261_e() + ": " + this.getIncreaseChance(stack.func_77973_b()) * 100.0f + "%"));
        if (stack.func_77973_b() == ModItems.FERTILIZER_CREATIVE) {
            tooltip.add((ITextComponent)new TextComponentString(new TextComponentTranslation("info.fertilizer_creative", new Object[0]).func_150261_e()));
        }
    }
}

