/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.librarys;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.librarys.utils.Drop;
import net.kaneka.planttech2.librarys.utils.Parents;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CropListEntry
implements Comparable<CropListEntry> {
    private int ID;
    private String name;
    private List<ItemStack> seeds = new ArrayList<ItemStack>();
    private ItemStack mainSeed = new ItemStack((IItemProvider)Items.field_151014_N);
    private Drop mainSeedDrop = new Drop(this.mainSeed, 1, 4);
    private int seedColor = 0xFFFFFF;
    private Set<Drop> drops = null;
    private Set<Parents> parents = null;
    private float chance = 0.0f;
    private ItemStack soil = ItemStack.field_190927_a;
    private EnumTemperature temp = EnumTemperature.NORMAL;
    private boolean hasParticle = false;
    private boolean isBlacklisted = false;

    public CropListEntry(int id, String name, int seedColor, boolean hasParticle) {
        this.ID = id;
        this.name = name;
        this.seedColor = seedColor;
        this.hasParticle = hasParticle;
    }

    public int getID() {
        return this.ID;
    }

    public String getString() {
        return this.name;
    }

    public String getDisplayNameUnformated() {
        return this.getDisplayName().func_150261_e();
    }

    public ITextComponent getDisplayName() {
        return new TextComponentTranslation("crop." + this.name, new Object[0]);
    }

    public int getSeedColor() {
        return this.seedColor;
    }

    public EnumTemperature getTemperature() {
        return this.temp;
    }

    public CropListEntry addSeeds(ItemStack ... seeds) {
        for (ItemStack seed : seeds) {
            this.seeds.add(seed);
        }
        return this;
    }

    public CropListEntry setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public ItemStack getSoil() {
        return this.soil;
    }

    public CropListEntry setSoil(ItemStack block) {
        this.soil = block;
        return this;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getMainSeed() {
        return this.mainSeed;
    }

    public Drop getMainSeedDrop() {
        return this.mainSeedDrop;
    }

    public List<ItemStack> getSeeds() {
        return this.seeds;
    }

    public CropListEntry setBlacklisted(boolean isBlacklisted) {
        this.isBlacklisted = isBlacklisted;
        return this;
    }

    public boolean isBlacklisted() {
        return this.isBlacklisted;
    }

    public CropListEntry addDrop(ItemStack item, int min, int max) {
        if (this.drops == null) {
            this.drops = new HashSet<Drop>();
        }
        this.drops.add(new Drop(item, min, max));
        return this;
    }

    public CropListEntry addParents(String parent1, String parent2, float chance) {
        if (!this.isBlacklisted) {
            if (this.parents == null) {
                this.parents = new HashSet<Parents>();
            }
            this.parents.add(new Parents(parent1, parent2, chance));
            this.chance = chance;
        }
        return this;
    }

    public CropListEntry setMainSeed(ItemStack item, int min, int max) {
        this.mainSeed = item;
        this.mainSeedDrop = new Drop(item, min, max);
        this.seeds.add(item);
        return this;
    }

    public boolean isSeed(ItemStack item) {
        for (ItemStack stack : this.seeds) {
            if (!stack.func_77969_a(item)) continue;
            return true;
        }
        return false;
    }

    public Set<Drop> getDrops() {
        return this.drops;
    }

    public NonNullList<ItemStack> calculateDrops(NonNullList<ItemStack> returndrops, HashMapCropTraits traits, int growstate) {
        Random rand = new Random();
        ItemStack seeddrop = this.mainSeedDrop.getDroppedStack(traits.getTrait(EnumTraitsInt.FERTILITY), EnumTraitsInt.FERTILITY.getMax(), rand);
        if (seeddrop != null) {
            if (growstate < 7) {
                seeddrop.func_190920_e(1);
            }
            returndrops.add((Object)traits.addToItemStack(seeddrop));
        }
        if (this.drops != null && growstate > 6) {
            for (Drop drop : this.drops) {
                ItemStack returndrop = drop.getDroppedStack(traits.getTrait(EnumTraitsInt.PRODUCTIVITY), EnumTraitsInt.PRODUCTIVITY.getMax(), rand);
                if (returndrop == null) continue;
                returndrops.add((Object)returndrop);
            }
        }
        return returndrops;
    }

    public NonNullList<ItemStack> calculateDropsReduced(NonNullList<ItemStack> returndrops, HashMapCropTraits traits, int growstate) {
        Random rand = new Random();
        ItemStack seeddrop = this.mainSeedDrop.getDroppedStack(traits.getTrait(EnumTraitsInt.FERTILITY), EnumTraitsInt.FERTILITY.getMax(), rand);
        if (seeddrop != null && growstate > 6 && seeddrop.func_190916_E() > 1) {
            seeddrop.func_190918_g(1);
            returndrops.add((Object)traits.addToItemStack(seeddrop));
        }
        if (this.drops != null && growstate > 6) {
            for (Drop drop : this.drops) {
                ItemStack returndrop = drop.getDroppedStack(traits.getTrait(EnumTraitsInt.PRODUCTIVITY), EnumTraitsInt.PRODUCTIVITY.getMax(), rand);
                if (returndrop == null) continue;
                returndrops.add((Object)returndrop);
            }
        }
        return returndrops;
    }

    public boolean isChild(String parent1, String parent2) {
        Boolean bool = false;
        if (this.parents != null) {
            for (Parents singleParent : this.parents) {
                if (!singleParent.isMatching(parent1, parent2)) continue;
                bool = true;
            }
        }
        return bool;
    }

    public Set<Parents> getParents() {
        return this.parents;
    }

    public boolean hasParents() {
        return this.parents != null;
    }

    public CropListEntry alternateTemperature(EnumTemperature temp) {
        this.temp = temp;
        return this;
    }

    @Override
    public int compareTo(CropListEntry o) {
        return o.getID() - this.ID;
    }

    public boolean hasParticle() {
        return this.hasParticle;
    }

    public void clearLists() {
        this.clearSeeds();
        this.clearDrops();
        this.clearParents();
    }

    public void clearSeeds() {
        if (this.seeds != null) {
            this.seeds.clear();
        }
    }

    public void clearDrops() {
        if (this.drops != null) {
            this.drops.clear();
        }
    }

    public void clearParents() {
        if (this.parents != null) {
            this.parents.clear();
        }
    }
}

